package org.jboss.jsr299.tck.tests.implementation.producer.method.definition.enterprise;

import javax.inject.AnnotationLiteral;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

@IntegrationTest
@Artifact
@BeansXml("beans.xml")
@Packaging(PackagingType.EAR)
public class EnterpriseProducerMethodDefinitionTest extends AbstractJSR299Test
{
   @Test
   @SpecAssertion(section = "4.2", id = "dd")
   public void testNonStaticProducerMethodInheritedBySpecializingSubclass()
   {
      assert getCurrentManager().resolveByType(Egg.class, new AnnotationLiteral<Yummy>() {}).size() == 1;
      assert getCurrentManager().getInstanceByType(Egg.class, new AnnotationLiteral<Yummy>() {}).getMother().getClass().equals(AndalusianChicken.class);
   }
   
   @Test
   @SpecAssertions({
      @SpecAssertion(section = "4.2", id = "dd"),
      @SpecAssertion(section = "4.2", id = "dj")
   })
   public void testNonStaticProducerMethodNotInherited()
   {
      assert getCurrentManager().resolveByType(Apple.class, new AnnotationLiteral<Yummy>() {}).size() == 1;
      assert getCurrentManager().getInstanceByType(Apple.class, new AnnotationLiteral<Yummy>() {}).getTree().getClass().equals(AppleTree.class);      
   }
}

