package org.jboss.jsr299.tck.tests.implementation.producer.method.disposal.definition;

import javax.inject.DefinitionException;
import javax.inject.UnsatisfiedDependencyException;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: Public Release Draft 2
 * 
 */
public class DisposalMethodDefinitionTest
{

   /**
    * A disposal method must be a method of a simple bean class or session bean
    * class.
    */
   @Test(groups = { "stub", "disposalMethod" })
   @SpecAssertions({
      @SpecAssertion(section = "3.4.6", id = "a"),
      @SpecAssertion(section = "3.4.6", id = "c")
   })
   public void testDisposalMethodMustBeOnSimpleOrSessionBean()
   {
      assert false;
   }

   /**
    * A disposal method may be either static or non-static
    */
   @Test(groups = { "stub", "disposalMethod" })
   @SpecAssertion(section = "3.4.6", id = "b")
   public void testDisposalMethodCanBeStatic()
   {
      assert false;
   }

   /**
    * A bean may declare multiple disposal methods
    */
   @Test(groups = { "stub", "disposalMethod" })
   @SpecAssertion(section = "3.4.6", id = "e")
   public void testBeanCanDeclareMultipleDisposalMethods()
   {
      assert false;
   }

   /**
    * Each disposal method must have exactly one disposed parameter, of the same
    * type as the corresponding producer method return type
    */
   @Test(groups = { "stub", "disposalMethod" })
   @SpecAssertion(section = "3.4.7", id = "a")
   public void testDisposalMethodCanHaveOnlyOneDisposedParameter()
   {
      assert false;
   }

   /**
    * When searching for disposal methods for a producer method, the container
    * considers the type and bindings of the disposed parameter.
    */
   @Test(groups = { "stub", "disposalMethod" })
   @SpecAssertion(section = "3.4.7", id = "b")
   public void testContainerUsesTypeAndBindingsForDisposalMethodSearch()
   {
      assert false;
   }

   /**
    * If a disposed parameter resolves to a producer method according to the
    * typesafe resolution algorithm, the container must call this method when
    * destroying an instance returned by that producer method.
    */
   @Test(groups = { "stub", "disposalMethod" })
   @SpecAssertion(section = "3.4.7", id = "d")
   public void testContainerCallsDisposalMethodOnDestructionOfProducedInstance()
   {
      assert false;
   }

   /**
    * If the disposed parameter does not resolve to any producer method
    * according to the typesafe resolution algorithm, an
    * UnsatisfiedDependencyException is thrown by the container at deployment
    * time
    */
   @Test(groups = { "stub", "disposalMethod" }, expectedExceptions = { UnsatisfiedDependencyException.class })
   @SpecAssertion(section = "3.4.7", id = "c")
   public void testDisposalMethodOnUnresolvableTypeFails()
   {
      assert false;
   }

   /**
    * A disposal method may be declared using annotations by annotating a
    * parameter @javax.inject.Disposes. That parameter is the disposed parameter
    */
   @Test(groups = { "stub", "disposalMethod" })
   @SpecAssertion(section = "3.4.8", id = "a")
   public void testDisposalMethodDeclaredByAnnotation()
   {
      assert false;
   }

   /**
    * If a method has more than one parameter annotated @Disposes, a
    * DefinitionException is thrown by the container
    */
   @Test(groups = { "stub", "disposalMethod" }, expectedExceptions = { DefinitionException.class })
   @SpecAssertion(section = "3.4.8", id = "b")
   public void testMoreThanOneDisposalParameterFails()
   {
      assert false;
   }

   /**
    * If a disposal method is annotated @Produces, or @Initializer or has a
    * parameter annotated @Observes, a DefinitionException is thrown by the
    * container at deployment time
    */
   @Test(groups = { "stub", "disposalMethod" }, expectedExceptions = { DefinitionException.class })
   @SpecAssertion(section = "3.4.8", id = "c")
   public void testDisposalMethodWithProducesFails()
   {
      assert false;
   }

   /**
    * If a disposal method is annotated @Produces, or @Initializer or has a
    * parameter annotated @Observes, a DefinitionException is thrown by the
    * container at deployment time
    */
   @Test(groups = { "stub", "disposalMethod" }, expectedExceptions = { DefinitionException.class })
   @SpecAssertion(section = "3.4.8", id = "d")
   public void testDisposalMethodWithInitializerFails()
   {
      assert false;
   }

   /**
    * If a disposal method is annotated @Produces, or @Initializer or has a
    * parameter annotated @Observes, a DefinitionException is thrown by the
    * container at deployment time
    */
   @Test(groups = { "stub", "disposalMethod" }, expectedExceptions = { DefinitionException.class })
   @SpecAssertion(section = "3.4.8", id = "e")
   public void testDisposalMethodWithObservesFails()
   {
      assert false;
   }

   /**
    * In addition to the disposed parameter, a disposal method may declare
    * additional parameters, which may also specify bindings. The container
    * calls Manager.getInstanceToInject() to determine a value for each
    * parameter of a disposal method and calls the disposal method with those
    * parameter values
    */
   @Test(groups = { "stub", "disposalMethod" })
   @SpecAssertion(section = "3.4.10", id = "a")
   public void testDisposalMethodParametersGetInjected()
   {
      assert false;
   }

   /**
    * When searching for disposal methods for a producer method, the container
    * searches for disposal methods which are declared by an enabled bean, and
    * for which the disposed parameter must resolve to the producer method,
    * according to the typesafe resolution algorithm
    */
   @Test(groups = { "stub", "disposalMethod" })
   @SpecAssertion(section = "3.4.11", id = "a")
   public void testDisposalMethodTypeSafeResolution()
   {
      assert false;
   }

   /**
    * If there are multiple disposal methods for a producer method, a
    * DefinitionException is thrown by the container at deployment time
    */
   @Test(groups = { "stub", "disposalMethod" }, expectedExceptions = { DefinitionException.class })
   @SpecAssertion(section = "3.4.11", id = "b")
   public void testMultipleDisposalMethodsFails()
   {
      assert false;
   }

}
