package org.jboss.jsr299.tck.tests.implementation.producer.method.lifecycle;

import javax.context.Dependent;
import javax.inject.IllegalProductException;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 * 
 */
@Artifact
@BeansXml("beans.xml")
public class ProducerMethodLifecycleTest extends AbstractJSR299Test
{

   @Test(groups = { "producerMethod", "disposalMethod" })
   @SpecAssertions({
      @SpecAssertion(section = "6", id = "f"),
      @SpecAssertion(section = "6.7", id = "m"),
      @SpecAssertion(section = "6.7", id = "o"),
      @SpecAssertion(section = "6.7", id = "p"),
      @SpecAssertion(section = "6.7", id = "q"),
      @SpecAssertion(section = "6.7", id = "r")
   })
   public void testProducerMethodBeanDestroy() throws Exception
   {
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            SpiderProducer.setTarantulaDestroyed(false);
            Tarantula tarantula = getCurrentManager().getInstanceByType(Tarantula.class);
            Bean<Tarantula> tarantulaBean = getCurrentManager().resolveByType(Tarantula.class).iterator().next();
            tarantulaBean.destroy(tarantula);
            assert SpiderProducer.isTarantulaDestroyed();
            assert SpiderProducer.isDestroyArgumentsSet();
            assert !SpiderProducerNotUsed.isTarantulaDestroyed();
         }
         
      }.run();
   }

   @Test(groups = { "producerMethod" })
   @SpecAssertions({
      @SpecAssertion(section = "6", id = "b")
   })
   public void testProducerMethodBeanCreate() throws Exception
   {
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            getCurrentManager().getInstanceByType(Tarantula.class);
            assert SpiderProducer.isTarantulaCreated();
         }
         
      }.run();
   }

   @Test(groups = { "producerMethod" })
   @SpecAssertions({
      @SpecAssertion(section = "6.7", id = "e")
   })
   public void testProducerMethodInvokedOnCreate() throws Exception
   {
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            Bean<SpiderEgg> eggBean = getCurrentManager().resolveByType(SpiderEgg.class).iterator().next();
            assert eggBean.create(new MockCreationalContext<SpiderEgg>()) != null;
         }
         
      }.run();      
   }

   @Test(groups = { "producerMethod" })
   @SpecAssertions({
      @SpecAssertion(section = "6.7", id = "g"),
      @SpecAssertion(section = "6.7", id = "h"),
      @SpecAssertion(section = "6.7", id = "i"),
      @SpecAssertion(section = "6.7", id = "j")
   })
   public void testProducerMethodFromMostSpecializedBeanUsed() throws Exception
   {
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {
            Tarantula.setNumberCreated(0);
            Bean<Tarantula> spiderBean = getCurrentManager().resolveByType(Tarantula.class).iterator().next();
            Tarantula tarantula = getCurrentManager().getInstance(spiderBean);
            assert tarantula.getValue().equals("Pete");
            assert Tarantula.getNumberCreated() == 1;
         }
      }.run();      
   }
   
   @Test(groups = { "producerMethod" })
   @SpecAssertions({
      @SpecAssertion(section = "6.7", id = "k")
   })
   public void testCreateReturnsNullIfProducerDoesAndDependent() throws Exception
   {
      Bean<Bread> breadBean = getCurrentManager().resolveByType(Bread.class).iterator().next();
      assert breadBean.create(new MockCreationalContext<Bread>()) == null;
   }

   @Test(groups = { "producerMethod" }, expectedExceptions = IllegalProductException.class )
   @SpecAssertions({
      @SpecAssertion(section = "6.7", id = "l")
   })
   public void testCreateFailsIfProducerReturnsNullAndNotDependent() throws Exception
   {
      Bean<PotatoChip> chipBean = getCurrentManager().resolveByType(PotatoChip.class).iterator().next();
      assert chipBean.create(new MockCreationalContext<PotatoChip>()) == null;
   }
}
