package org.jboss.jsr299.tck.tests.implementation.simple.lifecycle.ic;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.testng.annotations.Test;

@Artifact
@Packaging(PackagingType.EAR)
@IntegrationTest
public class SimpleBeanEEInjectionsTest extends AbstractJSR299Test
{
   @Test(groups = { "stub", "beanLifecycle", "commonAnnotations", "integration" })
   @SpecAssertion(section = "6.4", id = "b")
   public void testCreateInjectsEjb()
   {
      SimpleWithEjb bean = getCurrentManager().getInstanceByType(SimpleWithEjb.class);
      assert bean.isEjbInjected();
   }

   @Test(groups = { "stub", "beanLifecycle", "commonAnnotations", "integration" })
   @SpecAssertion(section = "6.4", id = "c")
   public void testCreateInjectsPersistenceContext()
   {
      assert false;
   }

   @Test(groups = { "broken", "beanLifecycle", "commonAnnotations", "integration" })
   @SpecAssertion(section = "6.4", id = "d")
   public void testCreateInjectsResource()
   {
      //TODO Spec defines resources for EJBs, not simple beans
      SimpleWithResources bean = getCurrentManager().getInstanceByType(SimpleWithResources.class);
      assert bean.getMyResourceId() == 42;
      assert "SimpleResource".equals(bean.getMyResourceName());
   }
}
