package org.jboss.jsr299.tck.tests.inheritance.realization;

import java.lang.annotation.Annotation;

import javax.context.RequestScoped;
import javax.inject.AnnotationLiteral;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 * 
 */
@Artifact
@BeansXml("beans.xml")
public class RealizationTest extends AbstractJSR299Test
{

   private static Annotation SMELLY_LITERAL = new AnnotationLiteral<Smelly>()
   {
   };
   private static Annotation TAME_LITERAL = new AnnotationLiteral<Tame>()
   {
   };

   @Test
   @SpecAssertion(section = "4.4.1", id = "ca")
   public void testRealizedBeanWithProducerMethodHasSameScope()
   {
      assert getCurrentManager().resolveByType(CowDung.class, SMELLY_LITERAL).size() == 1;
      assert getCurrentManager().resolveByType(CowDung.class, SMELLY_LITERAL).iterator().next().getScopeType().equals(RequestScoped.class);
   }

   @Test
   @SpecAssertion(section = "4.4.1", id = "ca")
   public void testRealizedBeanWithProducerMethodHasDeploymentTypeOfRealizingClass()
   {
      assert getCurrentManager().resolveByType(CowDung.class, SMELLY_LITERAL).size() == 1;
      assert getCurrentManager().resolveByType(CowDung.class, SMELLY_LITERAL).iterator().next().getDeploymentType().equals(AnotherDeploymentType.class);
   }

   @Test
   @SpecAssertion(section = "4.4.1", id = "ca")
   public void testRealizedBeanWithProducerMethodHasSameBindings()
   {
      assert getCurrentManager().resolveByType(CowDung.class, SMELLY_LITERAL).size() == 1;
      assert getCurrentManager().resolveByType(CowDung.class, SMELLY_LITERAL).iterator().next().getBindings().size() == 1;
      assert getCurrentManager().resolveByType(CowDung.class, SMELLY_LITERAL).iterator().next().getBindings().iterator().next().annotationType().equals(Smelly.class);
   }

   @SuppressWarnings("unchecked")
   @Test
   @SpecAssertion(section = "4.4.1", id = "ca")
   public void testRealizedBeanWithProducerMethodHasBindingsOfMethodAndRealizingType()
   {
      assert getCurrentManager().resolveByType(CowDung.class, SMELLY_LITERAL, TAME_LITERAL).size() == 1;
      assert getCurrentManager().resolveByType(CowDung.class, SMELLY_LITERAL, TAME_LITERAL).iterator().next().getBindings().size() == 2;
      assert annotationSetMatches(getCurrentManager().resolveByType(CowDung.class, SMELLY_LITERAL, TAME_LITERAL).iterator().next().getBindings(), Smelly.class, Tame.class);
   }

   @Test
   @SpecAssertion(section = "4.4.1", id = "ca")
   public void testRealizedBeanWithProducerMethodHasSameStereotypes()
   {
      assert getCurrentManager().resolveByType(Dog.class).size() == 1;
      assert getCurrentManager().resolveByType(Dog.class).iterator().next().getScopeType().equals(RequestScoped.class);
   }

   @Test
   @SpecAssertion(section = "4.4.1", id = "cb")
   public void testRealizedBeanWithProducerFieldHasSameScope()
   {
      assert getCurrentManager().resolveByType(HorseDung.class, SMELLY_LITERAL).size() == 1;
      assert getCurrentManager().resolveByType(HorseDung.class, SMELLY_LITERAL).iterator().next().getScopeType().equals(RequestScoped.class);
   }

   @Test
   @SpecAssertion(section = "4.4.1", id = "cb")
   public void testRealizedBeanWithProducerFieldHasDeploymentTypeOfRealizingClass()
   {
      assert getCurrentManager().resolveByType(HorseDung.class, SMELLY_LITERAL).size() == 1;
      assert getCurrentManager().resolveByType(HorseDung.class, SMELLY_LITERAL).iterator().next().getDeploymentType().equals(AnotherDeploymentType.class);
   }

   @Test
   @SpecAssertion(section = "4.4.1", id = "cb")
   public void testRealizedBeanWithProducerFieldHasSameBindings()
   {
      assert getCurrentManager().resolveByType(HorseDung.class, SMELLY_LITERAL).size() == 1;
      assert getCurrentManager().resolveByType(HorseDung.class, SMELLY_LITERAL).iterator().next().getBindings().size() == 1;
      assert getCurrentManager().resolveByType(HorseDung.class, SMELLY_LITERAL).iterator().next().getBindings().iterator().next().annotationType().equals(Smelly.class);
   }

   @SuppressWarnings("unchecked")
   @Test
   @SpecAssertion(section = "4.4.1", id = "cb")
   public void testRealizedBeanWithProducerFieldHasBindingsOfMethodAndRealizingType()
   {
      assert getCurrentManager().resolveByType(HorseDung.class, SMELLY_LITERAL, TAME_LITERAL).size() == 1;
      assert getCurrentManager().resolveByType(HorseDung.class, SMELLY_LITERAL, TAME_LITERAL).iterator().next().getBindings().size() == 2;
      assert annotationSetMatches(getCurrentManager().resolveByType(HorseDung.class, SMELLY_LITERAL, TAME_LITERAL).iterator().next().getBindings(), Smelly.class, Tame.class);
   }

   @Test
   @SpecAssertion(section = "4.4.1", id = "cb")
   public void testRealizedBeanWithProducerFieldHasSameStereotypes()
   {
      assert getCurrentManager().resolveByType(Donkey.class).size() == 1;
      assert getCurrentManager().resolveByType(Donkey.class).iterator().next().getScopeType().equals(RequestScoped.class);
   }

   @Test(groups = "stub")
   @SpecAssertion(section = "4.4.1", id = "d")
   public void testDisposalMethodInherited()
   {
      assert false;
   }

   @Test(groups = "stub")
   @SpecAssertion(section = "4.4.1", id = "d")
   public void testRealizedDisposalMethodHasBindingsOfMethodAndRealizingType()
   {
      assert false;
   }

   @Test
   @SpecAssertion(section = "4.4.1", id = "d")
   public void testObserverMethodInheritedAndHasSameBindings()
   {
      assert getCurrentManager().resolveObservers(new Cow(), new AnnotationLiteral<Tame>()
      {
      }).size() == 1;
      assert getCurrentManager().resolveObservers(new Cow(), SMELLY_LITERAL).size() == 0;
   }

}
