package org.jboss.jsr299.tck.tests.inheritance.specialization.enterprise;

import java.lang.annotation.Annotation;

import javax.inject.AnnotationLiteral;
import javax.inject.DefinitionException;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 */
@Artifact
@Packaging(PackagingType.EAR)
@BeansXml("beans.xml")
public class EnterpriseBeanSpecializationTest extends AbstractJSR299Test
{
   
   private static Annotation LANDOWNER_LITERAL = new AnnotationLiteral<Landowner>() {};

   @Test 
   @SpecAssertions({
     @SpecAssertion(section = "4.3.1", id = "c"),
     @SpecAssertion(section = "3.3.7", id = "a")
   })
   public void testSpecializingBeanHasBindingsOfSpecializedAndSpecializingBean()
   {
      assert getCurrentManager().resolveByType(FarmerLocal.class, LANDOWNER_LITERAL).size() == 1;
      Bean<FarmerLocal> bean = getCurrentManager().resolveByType(FarmerLocal.class, LANDOWNER_LITERAL).iterator().next();
      assert getCurrentManager().resolveByType(FarmerLocal.class, LANDOWNER_LITERAL).iterator().next().getTypes().contains(LazyFarmerLocal.class);
      assert getCurrentManager().resolveByType(FarmerLocal.class, LANDOWNER_LITERAL).iterator().next().getBindings().size() == 2;
      assert annotationSetMatches( getCurrentManager().resolveByType(FarmerLocal.class, LANDOWNER_LITERAL).iterator().next().getBindings(), Landowner.class, Lazy.class);
   }
   
   @Test
   @SpecAssertions({
     @SpecAssertion(section = "4.3.1", id = "d"),
     @SpecAssertion(section = "3.3.7", id = "a")
   })
   public void testSpecializingBeanHasNameOfSpecializedBean()
   {
      assert getCurrentManager().resolveByType(FarmerLocal.class, LANDOWNER_LITERAL).size() == 1;
      assert getCurrentManager().resolveByType(FarmerLocal.class, LANDOWNER_LITERAL).iterator().next().getTypes().contains(LazyFarmerLocal.class);
      assert getCurrentManager().resolveByType(FarmerLocal.class, LANDOWNER_LITERAL).iterator().next().getName().equals("farmer");
   }
   
   @Test(groups={"stub", "specialization"},expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section="3.3.7", id = "a")
   public void testSpecializingBeanDoesNotSupportAllLocalInterfacesOnSpecializedBean()
   {
      assert false;
   }
   
   @Test(groups={"stub", "specialization"},expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section="3.3.7", id = "a")
   public void testSpecializingBeanDoesNotSupportLocalInterfaceView()
   {
      assert false;
   }

}
