package org.jboss.jsr299.tck.tests.inheritance.specialization.simple;

import java.lang.annotation.Annotation;

import javax.inject.AnnotationLiteral;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

/**
 * Spec version: PRD2
 * 
 */
@Artifact
@BeansXml("beans.xml")
public class SimpleBeanSpecializationTest extends AbstractJSR299Test
{

   private static Annotation LANDOWNER_LITERAL = new AnnotationLiteral<Landowner>()
   {
   };

   @SuppressWarnings("unchecked")
   @Test
   @SpecAssertions( { 
      @SpecAssertion(section = "4.3.1", id = "c"), 
      @SpecAssertion(section = "3.2.7", id = "a") 
   })
   public void testSpecializingBeanHasBindingsOfSpecializedAndSpecializingBean()
   {
      assert getCurrentManager().resolveByType(Farmer.class, LANDOWNER_LITERAL).size() == 1;
      Bean<?> bean = getCurrentManager().resolveByType(Farmer.class, LANDOWNER_LITERAL).iterator().next();
      assert bean.getTypes().contains(LazyFarmer.class);
      assert bean.getBindings().size() == 2;
      assert annotationSetMatches(bean.getBindings(), Landowner.class, Lazy.class);
   }

   @Test
   @SpecAssertions( { 
      @SpecAssertion(section = "4.3.1", id = "d"), 
      @SpecAssertion(section = "3.2.7", id = "a") 
   })
   public void testSpecializingBeanHasNameOfSpecializedBean()
   {
      assert getCurrentManager().resolveByType(Farmer.class, LANDOWNER_LITERAL).size() == 1;
      assert getCurrentManager().resolveByType(Farmer.class, LANDOWNER_LITERAL).iterator().next().getTypes().contains(LazyFarmer.class);
      assert "farmer".equals(getCurrentManager().resolveByType(Farmer.class, LANDOWNER_LITERAL).iterator().next().getName());
   }

   @Test
   @SpecAssertions( { 
      @SpecAssertion(section = "4.3.1", id = "f"), 
      @SpecAssertion(section = "3.2.7", id = "b") 
   })
   public void testSpecializedBeanNotInstantiated() throws Exception
   {
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            Farmer farmer = getCurrentManager().getInstanceByType(Farmer.class, LANDOWNER_LITERAL);
            assert farmer.getClassName().equals(LazyFarmer.class.getName());
         }

      }.run();
   }

   @Test
   @SpecAssertion(section = "4.3.1", id = "g")
   public void testProducerMethodOnSpecializedBeanCalledOnSpecializingBean() throws Exception
   {
//      deployBeans(Office.class, Building.class);
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            assert getCurrentManager().resolveByType(Waste.class).size() == 1;
            assert getCurrentManager().getInstanceByType(Waste.class).getFrom().equals(Office.class.getName());
         }

      }.run();
   }

}
