package org.jboss.jsr299.tck.tests.lookup.dynamic;

import static org.jboss.jsr299.tck.tests.lookup.dynamic.PayBy.PaymentMethod.CHEQUE;

import javax.inject.DuplicateBindingTypeException;
import javax.inject.Instance;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * Tests for dynamic lookup features
 * 
 * @author Shane Bryzak
 */
@Artifact
public class DynamicLookupTest extends AbstractJSR299Test
{
   @Test
   @SpecAssertions({
      @SpecAssertion(section = "5.8", id ="a"),
      @SpecAssertion(section = "5.8", id ="f")
   })
   public void testObtainsInjectsInstanceOfInstance()
   {
      Bean<ObtainsInjectionPointBean> injectionPointBean = 
         getCurrentManager().resolveByType(ObtainsInjectionPointBean.class).iterator().next();
      
      ObtainsInjectionPointBean injectionPoint = getCurrentManager().getInstance(injectionPointBean);      
      assert injectionPoint.getPaymentProcessor() instanceof Instance;
   }
   
   @Test
   @SpecAssertions({
      @SpecAssertion(section = "5.8", id ="b"),
      @SpecAssertion(section = "5.8", id ="c"),
      @SpecAssertion(section = "5.8", id ="q")
   })
   public void testDynamicLookup()
   {
      Bean<ObtainsInjectionPointBean> injectionPointBean = 
         getCurrentManager().resolveByType(ObtainsInjectionPointBean.class).iterator().next();
      
      ObtainsInjectionPointBean injectionPoint = getCurrentManager().getInstance(injectionPointBean);
      assert injectionPoint.getPaymentProcessor().get() instanceof ChequePaymentProcessor;      
   }   
   
   @Test(expectedExceptions = DuplicateBindingTypeException.class)
   @SpecAssertion(section = "5.8", id ="d")   
   public void testDuplicateBindingsThrowsException()
   {
      Bean<ObtainsInjectionPointBean> injectionPointBean = 
         getCurrentManager().resolveByType(ObtainsInjectionPointBean.class).iterator().next();
      
      ObtainsInjectionPointBean injectionPoint = getCurrentManager().getInstance(injectionPointBean);
      injectionPoint.getPaymentProcessor().get(new PayByBinding() { public PaymentMethod value() { return CHEQUE; }});      
   }      
   
   @Test(expectedExceptions = IllegalArgumentException.class)
   @SpecAssertion(section = "5.8", id = "e")
   public void testNonBindingThrowsException()
   {
      Bean<ObtainsInjectionPointBean> injectionPointBean = 
         getCurrentManager().resolveByType(ObtainsInjectionPointBean.class).iterator().next();
      
      ObtainsInjectionPointBean injectionPoint = getCurrentManager().getInstance(injectionPointBean);
      injectionPoint.getPaymentProcessor().get(new NonBinding() );      
   }
   
}
