package org.jboss.jsr299.tck.tests.lookup.injection.enterprise;

import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 */
@IntegrationTest
@Artifact
@Packaging(PackagingType.EAR)
public class EnterpriseBeanInjectionTest extends AbstractJSR299Test
{   
   @Test
   @SpecAssertion(section = "4.2", id = "ab")
   public void testFieldDeclaredInSessionBeanSuperclassInjected() throws Exception
   {
      new RunInDependentContext()
      {
        @Override
         protected void execute() throws Exception
         {
           Bean<HenHouseLocal> bean = getCurrentManager().resolveByType(HenHouseLocal.class).iterator().next();
           HenHouseLocal henHouse = getCurrentManager().getInstance(bean);
           assert henHouse.getFox() != null;
           assert henHouse.getFox().getName().equals("gavin");
         }
      }.run();     
   }

   @Test
   @SpecAssertion(section = "4.2", id = "ad")
   public void testFieldDeclaredInSessionBeanIndirectSuperclassInjected() throws Exception
   {
      new RunInDependentContext()
      {
        @Override
         protected void execute() throws Exception
         {
           Bean<HenHouseLocal> bean = getCurrentManager().resolveByType(HenHouseLocal.class, new MegaPoorBinding()).iterator().next();
           HenHouseLocal henHouse = getCurrentManager().getInstance(bean);
           assert henHouse.getFox() != null;
           assert henHouse.getFox().getName().equals("gavin");
         }
      }.run();      
   }
}
