package org.jboss.jsr299.tck.tests.xml.metadata;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.jsr299.tck.tests.xml.metadata.foo.AnotherDeploymentType;
import org.jboss.jsr299.tck.tests.xml.metadata.foo.Order;
import org.jboss.jsr299.tck.tests.xml.metadata.foo.another.AnotherOrder;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.Classes;
import org.jboss.testharness.impl.packaging.Resource;
import org.jboss.testharness.impl.packaging.Resources;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

@Artifact
@Resources({
   @Resource(source="schema.xsd", destination="WEB-INF/classes/org/jboss/jsr299/tck/tests/xml/metadata/schema.xsd")
})
@Classes({
   Order.class,
   AnotherOrder.class,
   AnotherDeploymentType.class
})
@BeansXml("beans.xml")
public class XmlBasedMetadataTest extends AbstractJSR299Test
{
   @Test
   @SpecAssertions({
      @SpecAssertion(section="9", id="b"),
      @SpecAssertion(section="9", id="c"),
      @SpecAssertion(section="9", id="d"),//with schema
      @SpecAssertion(section="9.1", id="a"),
      @SpecAssertion(section="9.1", id="b"),
      @SpecAssertion(section="9.1", id="c"),
      @SpecAssertion(section="9.1", id="d")
   })
   public void testXmlBasedMetadata()
   {
      assert getCurrentManager().resolveByType(Order.class).size() == 1;
      assert getCurrentManager().resolveByType(AnotherOrder.class).size() == 1;
   }
}
