package org.jboss.jsr299.tck.tests.xml.namespace.javaee.pkg.foo;

import java.util.Date;

import javax.annotation.Named;
import javax.context.RequestScoped;
import javax.ejb.TimerHandle;
import javax.event.Event;
import javax.inject.Initializer;
import javax.inject.Produces;
import javax.interceptor.InvocationContext;
import javax.persistence.EntityManager;
import javax.sql.CommonDataSource;
import javax.xml.ws.Binding;

@Named("orderBean")
@RequestScoped
public class Order
{
   private final Integer integer; 
   
   private final Date date;
   
   @Initializer
   public Order()
   {
      this(0, new Date(), null, null, null, null, null, null);
   }
   
   public Order(Integer integer, Date date, CommonDataSource source, InvocationContext invocation, Event e, TimerHandle schedule, 
         EntityManager entityManager, Binding binding)
   {
      this.integer = integer;
      this.date = date;
   }
   
   @Produces
   public Order getOrder()
   {
      return new Order();
   }

   public Integer getInteger()
   {
      return integer;
   }

   public Date getDate()
   {
      return date;
   }
}
