package org.jboss.jsr299.tck.tests.xml.resource.resource;

import javax.inject.AnnotationLiteral;
import javax.inject.manager.Manager;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

@Artifact
@Packaging(PackagingType.WAR)
@IntegrationTest
@BeansXml("beans.xml")
public class InjectionOfResourceTest extends AbstractJSR299Test
{
   @Test(groups = { "xml" })
   @SpecAssertions( { 
      @SpecAssertion(section = "6.9", id = "f"), 
      @SpecAssertion(section = "3.6", id = "a"),
      @SpecAssertion(section = "3.6", id = "f"),
      @SpecAssertion(section = "3.6.1", id = "a"),
      @SpecAssertion(section = "3.6.1", id = "f")
   })
   public void testInjectionOfResource()
   {
      Manager manager = getCurrentManager().getInstanceByType(Manager.class, new AnnotationLiteral<Another>() {});
      assert manager != null : "@Another Manager was not injected into bean";
      assert manager.equals(getCurrentManager()): "Wrong manager injected into bean";
   }
}
