/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.integration;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ReflectiveAspectBinder;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.microcontainer.annotations.DisabledType;
import org.jboss.aop.microcontainer.beans.AspectManagerFactory;
import org.jboss.aop.microcontainer.beans.ManagedAspectDefinition;
import org.jboss.aop.microcontainer.integration.AnnotationDependencyBuilderListItem;
import org.jboss.aop.microcontainer.integration.AspectDependencyBuilderListItem;
import org.jboss.aop.microcontainer.integration.DisableAOPHelper;
import org.jboss.aop.proxy.container.ContainerCache;
import org.jboss.aop.util.Advisable;
import org.jboss.aop.util.ClassInfoMethodHashing;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.api.annotations.Dependency;
import org.jboss.kernel.spi.dependency.DependencyBuilderListItem;
import org.jboss.kernel.spi.dependency.helpers.AbstractDependencyBuilder;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.AnnotationValueFactory;
import org.jboss.reflect.plugins.introspection.IntrospectionAnnotationHelper;
import org.jboss.reflect.spi.AnnotationInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.reflect.spi.ArrayValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.StringValue;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.reflect.spi.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AOPDependencyBuilder
extends AbstractDependencyBuilder {
    private static final String DEPENDENCY_CLASS_NAME = Dependency.class.getName();
    private static final String DEPENDENCY_NAME_ATTRIBUTE = "name";
    private static final IntrospectionAnnotationHelper helper = new IntrospectionAnnotationHelper();

    protected boolean bypassAOP(BeanInfo beanInfo, MetaData metaData, DisabledType disabledType) {
        return DisableAOPHelper.isAOPDisabled(metaData, disabledType);
    }

    public List<DependencyBuilderListItem> getDependencies(BeanInfo beanInfo, MetaData metaData) {
        try {
            HashSet aspects;
            Class<?> clazz = this.getClass(beanInfo);
            if (clazz == null) {
                return super.getDependencies(beanInfo, metaData);
            }
            boolean classIsWoven = Advised.class.isAssignableFrom(clazz);
            if (!classIsWoven && this.bypassAOP(beanInfo, metaData, DisabledType.ALL)) {
                return super.getDependencies(beanInfo, metaData);
            }
            ReflectiveAspectBinder binder = null;
            ArrayList<DependencyBuilderListItem> depends = new ArrayList<DependencyBuilderListItem>();
            if ((classIsWoven || !this.bypassAOP(beanInfo, metaData, DisabledType.POINTCUTS)) && (aspects = (binder = this.getBinder(clazz, metaData)).getAspects()) != null && aspects.size() > 0) {
                for (AspectDefinition def : aspects) {
                    String name;
                    if (!(def instanceof ManagedAspectDefinition) || (name = ((ManagedAspectDefinition)def).getDependentAspectName()) == null) continue;
                    depends.add(new AspectDependencyBuilderListItem(name));
                }
            }
            HashSet<String> annotationDependencies = this.getAnnotationDependencies(beanInfo.getClassInfo(), metaData);
            for (String dependency : annotationDependencies) {
                depends.add(new AnnotationDependencyBuilderListItem(dependency));
            }
            return depends;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReflectiveAspectBinder getBinder(Class<?> clazz, MetaData metaData) {
        Advisor advisor;
        AspectManager manager = AspectManagerFactory.getAspectManager(metaData);
        Object object = ContainerCache.mapLock;
        synchronized (object) {
            ContainerCache cache = ContainerCache.initialise((AspectManager)manager, clazz, (MetaData)metaData, (boolean)true);
            advisor = cache.getAdvisor();
        }
        return new ReflectiveAspectBinder(clazz, advisor);
    }

    private Class<?> getClass(BeanInfo beanInfo) throws ClassNotFoundException {
        ClassInfo classInfo = beanInfo.getClassInfo();
        String className = classInfo.getName();
        if (className != null) {
            ClassLoader loader = classInfo.getType().getClassLoader();
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            return loader.loadClass(className);
        }
        return null;
    }

    private HashSet<String> getAnnotationDependencies(ClassInfo classInfo, MetaData metaData) {
        try {
            LinkedHashSet<String> dependencies = new LinkedHashSet<String>();
            this.getClassAnnotationDependencies(classInfo, metaData, dependencies);
            this.getMethodAnnotationDependencies(classInfo, metaData, dependencies);
            return dependencies;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void getClassAnnotationDependencies(ClassInfo classInfo, MetaData metaData, HashSet<String> dependencies) throws Exception {
        LinkedHashMap<String, ArrayList<String>> realMap = new LinkedHashMap<String, ArrayList<String>>();
        this.getRealClassAnnotationDependencies(classInfo, realMap);
        LinkedHashMap<String, ArrayList<String>> metaMap = new LinkedHashMap<String, ArrayList<String>>();
        this.getMetaDataClassAnnotationDependencies(metaData, metaMap);
        this.addAllDependenciesToSet(dependencies, realMap, metaMap);
    }

    private void getRealClassAnnotationDependencies(ClassInfo classInfo, HashMap<String, ArrayList<String>> dependencies) throws Exception {
        AnnotationValue[] annotations = classInfo.getAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            this.getDependenciesForAnnotation(annotations[i].getType().getName(), annotations[i], dependencies);
        }
    }

    private void getMetaDataClassAnnotationDependencies(MetaData metaData, HashMap<String, ArrayList<String>> dependencies) throws Exception {
        if (metaData != null) {
            for (Annotation annotation : metaData.getAnnotations()) {
                this.getDependenciesForMetaDataAnnotation(annotation, dependencies);
            }
        }
    }

    private void getMethodAnnotationDependencies(ClassInfo classInfo, MetaData metaData, HashSet<String> dependencies) throws Exception {
        HashMap methodMap = ClassInfoMethodHashing.getMethodMap((ClassInfo)classInfo);
        if (methodMap != null) {
            for (MethodInfo method : methodMap.values()) {
                if (!Advisable.isAdvisableMethod((int)method.getModifiers(), (String)method.getName())) continue;
                LinkedHashMap<String, ArrayList<String>> classMap = new LinkedHashMap<String, ArrayList<String>>();
                this.getRealMethodAnnotationDependencies(method, classMap);
                LinkedHashMap<String, ArrayList<String>> overrideMap = new LinkedHashMap<String, ArrayList<String>>();
                this.getMetaDataMethodAnnotationDependencies(method, metaData, overrideMap);
                this.addAllDependenciesToSet(dependencies, classMap, overrideMap);
            }
        }
    }

    private void getRealMethodAnnotationDependencies(MethodInfo methodInfo, HashMap<String, ArrayList<String>> dependencies) throws Exception {
        AnnotationValue[] annotations = methodInfo.getAnnotations();
        if (annotations != null) {
            for (int i = 0; i < annotations.length; ++i) {
                this.getDependenciesForAnnotation(annotations[i].getType().getName(), annotations[i], dependencies);
            }
        }
    }

    private void getMetaDataMethodAnnotationDependencies(MethodInfo method, MetaData metaData, HashMap<String, ArrayList<String>> dependencies) throws Exception {
        MetaData methodMetaData;
        if (metaData != null && (methodMetaData = metaData.getComponentMetaData((Signature)new MethodSignature(method))) != null) {
            for (Annotation annotation : methodMetaData.getAnnotations()) {
                this.getDependenciesForMetaDataAnnotation(annotation, dependencies);
            }
        }
    }

    private void getDependenciesForMetaDataAnnotation(Object annotation, HashMap<String, ArrayList<String>> dependencies) throws Exception {
        AnnotationInfo info;
        Class<?> clazz = annotation.getClass().getInterfaces()[0];
        try {
            info = (AnnotationInfo)helper.getTypeInfo(clazz);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error creating annotation for " + clazz.getName(), e);
        }
        AnnotationValue value = AnnotationValueFactory.createAnnotationValue((TypeInfoFactory)helper, (AnnotationHelper)helper, (AnnotationInfo)info, (Object)annotation);
        this.getDependenciesForAnnotation(info.getName(), value, dependencies);
    }

    private void getDependenciesForAnnotation(String topLevelAnnotationName, AnnotationValue annotation, HashMap<String, ArrayList<String>> dependencies) {
        if (annotation != null) {
            this.addAnnotationAttributeDependencies(topLevelAnnotationName, annotation, dependencies);
            AnnotationValue[] annotationAnnotations = annotation.getAnnotationType().getAnnotations();
            for (int i = 0; i < annotationAnnotations.length; ++i) {
                if (!annotationAnnotations[i].getAnnotationType().getName().equals(DEPENDENCY_CLASS_NAME)) continue;
                StringValue value = (StringValue)annotationAnnotations[i].getValue(DEPENDENCY_NAME_ATTRIBUTE);
                StringValue dependency = (StringValue)annotation.getValue(value.getValue());
                this.addDependency(topLevelAnnotationName, dependency, dependencies);
            }
        }
    }

    private void addAnnotationAttributeDependencies(String topLevelAnnotationName, AnnotationValue annotation, HashMap<String, ArrayList<String>> dependencies) {
        MethodInfo[] attributes = annotation.getAnnotationType().getDeclaredMethods();
        if (attributes != null) {
            for (int i = 0; i < attributes.length; ++i) {
                ArrayValue arrVal;
                TypeInfo type;
                Value value = annotation.getValue(attributes[i].getName());
                if (value instanceof AnnotationValue) {
                    this.getDependenciesForAnnotation(topLevelAnnotationName, (AnnotationValue)value, dependencies);
                    continue;
                }
                if (!(value instanceof ArrayValue) || !((type = ((ArrayInfo)(arrVal = (ArrayValue)value).getType()).getComponentType()) instanceof AnnotationInfo)) continue;
                Value[] values = arrVal.getValues();
                for (int j = 0; j < values.length; ++j) {
                    this.getDependenciesForAnnotation(topLevelAnnotationName, (AnnotationValue)values[j], dependencies);
                }
            }
        }
    }

    private void addDependency(String topLevelAnnotationName, StringValue dependency, HashMap<String, ArrayList<String>> dependencies) {
        ArrayList<String> list = dependencies.get(topLevelAnnotationName);
        if (list == null) {
            list = new ArrayList();
            dependencies.put(topLevelAnnotationName, list);
        }
        list.add(dependency.getValue());
    }

    private void addAllDependenciesToSet(HashSet<String> dependencies, HashMap<String, ArrayList<String>> classMap, HashMap<String, ArrayList<String>> overrideMap) {
        HashMap<String, ArrayList<String>> dependencyMap = this.mergeClassAndOverrideMaps(classMap, overrideMap);
        if (dependencyMap.size() > 0) {
            for (ArrayList<String> deps : dependencyMap.values()) {
                dependencies.addAll(deps);
            }
        }
    }

    private HashMap<String, ArrayList<String>> mergeClassAndOverrideMaps(HashMap<String, ArrayList<String>> classMap, HashMap<String, ArrayList<String>> overrideMap) {
        if (classMap.size() == 0 && overrideMap.size() == 0) {
            return classMap;
        }
        if (classMap.size() > 0 && overrideMap.size() == 0) {
            return classMap;
        }
        if (classMap.size() == 0 && overrideMap.size() > 0) {
            return overrideMap;
        }
        for (Map.Entry<String, ArrayList<String>> entry : overrideMap.entrySet()) {
            classMap.put(entry.getKey(), entry.getValue());
        }
        return classMap;
    }
}

