/*
* JBoss, Home of Professional Open Source
* Copyright 2010, Red Hat Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.dependency.plugins;

import java.util.Set;

import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;

/**
 * TrackingDependencyInfo
 *
 * @author adrian@jboss.org
 */
public interface TrackingDependencyInfo extends DependencyInfo
{
   /**
    * The item is resolved
    * 
    * @param item the item
    */
   void resolved(DependencyItem item);

   /**
    * The item is unresolved
    * 
    * @param item the item
    */
   void unresolved(DependencyItem item);

   /**
    * The item is semi resolved
    * 
    * @param item the item
    */
   void semiResolved(DependencyItem item);
   
   /**
    * Get the semi resolved dependencies for a state
    * 
    * @param state the state
    * @return the semi resolved dependencies
    */
   Set<DependencyItem> getSemiResolvedDependencies(ControllerState state);
   
   /**
    * Semi resolve a dependency item<p>
    * 
    * Checks whether the dependency can be resolved, if it cannot
    * puts the dependency in a semi-resolved state. It then
    * checks whether the semi-resolved context is in the previous
    * state and it or its transients has no unresolved dependencies.
    * 
    * @param item the item
    * @return the resolved state
    */
   ResolvedState semiResolve(TrackingDependencyItem item);
}
