/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.dependency.spi.tracker;

import org.jboss.dependency.spi.ControllerContext;

/**
 * Register contexts.
 *
 * @author <a href="ales.justin@jboss.org">Ales Justin</a>
 */
public interface ContextRegistry
{
   /**
    * Add instantiated context into the map used by {@link ContextQueries#getContextByClass(Class)}.
    * Look at all the context's target's superclasses and interfaces.
    *
    * @param context the context
    */
   void addInstantiatedContext(ControllerContext context);

   /**
    * Add instantiated context into the map used by {@link ContextQueries#getContextByClass(Class)}.
    * Only map against explicit classes.
    *
    * Note: it is up to the caller to make sure the context's target implements
    * all of the exposed classes.
    *
    * @param context the context
    * @param classes the classes to expose
    */
   void registerInstantiatedContext(ControllerContext context, Class<?>... classes);

   /**
    * Remove instantiated context from the map used by {@link ContextQueries#getContextByClass(Class)}.
    * Only remove explicit classes.
    *
    * @param context the context
    * @param classes the classes to expose
    */
   void unregisterInstantiatedContext(ControllerContext context, Class<?>... classes);

   /**
    * Remove instantiated context from the map used by {@link ContextQueries#getContextByClass(Class)}.
    * Look at all target's superclasses and interfaces.
    *
    * @param context the context
    */
   void removeInstantiatedContext(ControllerContext context);
}