/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.dependency.plugins.TrackingDependencyInfo;
import org.jboss.dependency.plugins.TrackingDependencyItem;
import org.jboss.dependency.spi.CallbackItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.dependency.spi.LifecycleCallbackItem;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.collection.ConcurrentSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractDependencyInfo
extends JBossObject
implements TrackingDependencyInfo {
    private volatile Set<DependencyItem> iDependOn;
    private volatile Set<DependencyItem> dependsOnMe;
    private volatile Set<CallbackItem<?>> installCallbacks;
    private volatile Set<CallbackItem<?>> uninstallCallbacks;
    private volatile List<LifecycleCallbackItem> lifecycleCallbacks;
    private volatile boolean autowireCandidate = true;
    volatile boolean tracking = true;
    private volatile Map<ControllerState, Set<DependencyItem>> unresolved;

    @Override
    public void resolved(DependencyItem item) {
        if (this.tracking) {
            Set<DependencyItem> items;
            ControllerState whenRequired = item.getWhenRequired();
            Map<ControllerState, Set<DependencyItem>> unresolved = this.unresolved;
            if (unresolved != null && (items = unresolved.get(whenRequired)) != null) {
                items.remove(item);
            }
        }
    }

    @Override
    public void unresolved(DependencyItem item) {
        if (this.tracking) {
            ConcurrentSet items;
            ControllerState whenRequired = item.getWhenRequired();
            Map<ControllerState, Set<DependencyItem>> unresolved = this.unresolved;
            if (unresolved == null) {
                unresolved = this.unresolved = new ConcurrentHashMap<ControllerState, Set<DependencyItem>>();
            }
            if ((items = unresolved.get(whenRequired)) == null) {
                items = new ConcurrentSet();
                unresolved.put(whenRequired, (Set<DependencyItem>)items);
            }
            items.add((DependencyItem)item);
        }
    }

    @Override
    public Set<DependencyItem> getIDependOn(Class<?> type) {
        Set<DependencyItem> iDependOn = this.iDependOn;
        if (iDependOn == null) {
            iDependOn = Collections.emptySet();
        }
        if (type == null || iDependOn.isEmpty()) {
            return iDependOn;
        }
        HashSet<DependencyItem> set = new HashSet<DependencyItem>();
        for (DependencyItem item : iDependOn) {
            if (!type.isInstance(item)) continue;
            set.add(item);
        }
        return set;
    }

    @Override
    public void addIDependOn(DependencyItem dependency) {
        Set<DependencyItem> iDependOn = this.iDependOn;
        if (iDependOn == null) {
            iDependOn = this.iDependOn = new CopyOnWriteArraySet<DependencyItem>();
        }
        iDependOn.add(dependency);
        this.flushJBossObjectCache();
        if (dependency instanceof TrackingDependencyItem) {
            ((TrackingDependencyItem)dependency).setDependencyInfo(this);
            if (this.tracking && !dependency.isResolved()) {
                ConcurrentSet items;
                ControllerState whenRequired = dependency.getWhenRequired();
                Map<ControllerState, Set<DependencyItem>> unresolved = this.unresolved;
                if (unresolved == null) {
                    unresolved = this.unresolved = new ConcurrentHashMap<ControllerState, Set<DependencyItem>>();
                }
                if ((items = unresolved.get(whenRequired)) == null) {
                    items = new ConcurrentSet();
                    unresolved.put(whenRequired, (Set<DependencyItem>)items);
                }
                items.add((DependencyItem)dependency);
            }
        } else if (this.tracking) {
            this.log.debug((Object)("Cannot track " + dependency));
            this.tracking = false;
            this.unresolved = null;
        }
    }

    @Override
    public void removeIDependOn(DependencyItem dependency) {
        Set<DependencyItem> iDependOn = this.iDependOn;
        if (iDependOn == null) {
            return;
        }
        iDependOn.remove(dependency);
        this.flushJBossObjectCache();
        if (dependency instanceof TrackingDependencyItem) {
            ((TrackingDependencyItem)dependency).setDependencyInfo(null);
            if (this.tracking) {
                Set<DependencyItem> items;
                ControllerState whenRequired = dependency.getWhenRequired();
                Map<ControllerState, Set<DependencyItem>> unresolved = this.unresolved;
                if (unresolved != null && (items = unresolved.get(whenRequired)) != null) {
                    items.remove(dependency);
                }
            }
        }
    }

    @Override
    public Set<DependencyItem> getDependsOnMe(Class<?> type) {
        Set<DependencyItem> dependsOnMe = this.dependsOnMe;
        if (dependsOnMe == null) {
            dependsOnMe = Collections.emptySet();
        }
        if (type == null || dependsOnMe.isEmpty()) {
            return dependsOnMe;
        }
        HashSet<DependencyItem> set = new HashSet<DependencyItem>();
        for (DependencyItem item : dependsOnMe) {
            if (!type.isInstance(item)) continue;
            set.add(item);
        }
        return set;
    }

    @Override
    public void addDependsOnMe(DependencyItem dependency) {
        Set<DependencyItem> dependsOnMe = this.dependsOnMe;
        if (dependsOnMe == null) {
            dependsOnMe = this.dependsOnMe = new CopyOnWriteArraySet<DependencyItem>();
        }
        dependsOnMe.add(dependency);
        this.flushJBossObjectCache();
    }

    @Override
    public void removeDependsOnMe(DependencyItem dependency) {
        Set<DependencyItem> dependsOnMe = this.dependsOnMe;
        if (dependsOnMe == null) {
            return;
        }
        dependsOnMe.remove(dependency);
        this.flushJBossObjectCache();
    }

    @Override
    public boolean resolveDependencies(Controller controller, ControllerState state) {
        boolean resolved = true;
        Set<DependencyItem> items = this.getUnresolvedDependencies(state);
        if (!items.isEmpty()) {
            for (DependencyItem item : items) {
                if (item.resolve(controller)) continue;
                resolved = false;
            }
        }
        return resolved;
    }

    @Override
    public Set<DependencyItem> getUnresolvedDependencies(ControllerState state) {
        Set<DependencyItem> iDependOn = this.iDependOn;
        if (iDependOn == null || iDependOn.isEmpty()) {
            return Collections.emptySet();
        }
        Set<DependencyItem> result = null;
        if (this.tracking && state != null) {
            Map<ControllerState, Set<DependencyItem>> unresolved = this.unresolved;
            if (unresolved != null) {
                result = unresolved.get(state);
            }
            if (result == null) {
                result = Collections.emptySet();
            }
            return result;
        }
        for (DependencyItem item : iDependOn) {
            if (state != null && !state.equals(item.getWhenRequired()) || item.isResolved()) continue;
            if (result == null) {
                result = new HashSet<DependencyItem>();
            }
            result.add(item);
        }
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    @Override
    public <T> void addInstallItem(CallbackItem<T> callbackItem) {
        Set<CallbackItem<?>> installCallbacks = this.installCallbacks;
        if (installCallbacks == null) {
            this.installCallbacks = new CopyOnWriteArraySet();
            installCallbacks = this.installCallbacks;
        }
        installCallbacks.add(callbackItem);
        this.flushJBossObjectCache();
    }

    @Override
    public <T> void removeInstallItem(CallbackItem<T> callbackItem) {
        Set<CallbackItem<?>> installCallbacks = this.installCallbacks;
        if (installCallbacks == null) {
            return;
        }
        installCallbacks.remove(callbackItem);
        this.flushJBossObjectCache();
    }

    @Override
    public Set<CallbackItem<?>> getInstallItems() {
        Set<CallbackItem<?>> installCallbacks = this.installCallbacks;
        if (installCallbacks == null) {
            return Collections.emptySet();
        }
        return installCallbacks;
    }

    @Override
    public <T> void addUninstallItem(CallbackItem<T> callbackItem) {
        Set<CallbackItem<?>> uninstallCallbacks = this.uninstallCallbacks;
        if (uninstallCallbacks == null) {
            this.uninstallCallbacks = new CopyOnWriteArraySet();
            uninstallCallbacks = this.uninstallCallbacks;
        }
        uninstallCallbacks.add(callbackItem);
        this.flushJBossObjectCache();
    }

    @Override
    public <T> void removeUninstallItem(CallbackItem<T> callbackItem) {
        Set<CallbackItem<?>> uninstallCallbacks = this.uninstallCallbacks;
        if (uninstallCallbacks == null) {
            return;
        }
        uninstallCallbacks.remove(callbackItem);
        this.flushJBossObjectCache();
    }

    @Override
    public Set<CallbackItem<?>> getUninstallItems() {
        Set<CallbackItem<?>> uninstallCallbacks = this.uninstallCallbacks;
        if (uninstallCallbacks == null) {
            return Collections.emptySet();
        }
        return uninstallCallbacks;
    }

    @Override
    public void addLifecycleCallback(LifecycleCallbackItem lifecycleCallbackItem) {
        List<LifecycleCallbackItem> lifecycleCallbacks = this.lifecycleCallbacks;
        if (lifecycleCallbacks == null) {
            lifecycleCallbacks = this.lifecycleCallbacks = new CopyOnWriteArrayList<LifecycleCallbackItem>();
        }
        lifecycleCallbacks.add(lifecycleCallbackItem);
    }

    @Override
    public List<LifecycleCallbackItem> getLifecycleCallbacks() {
        List<LifecycleCallbackItem> lifecycleCallbacks = this.lifecycleCallbacks;
        if (lifecycleCallbacks == null) {
            return Collections.emptyList();
        }
        return lifecycleCallbacks;
    }

    @Override
    public boolean isAutowireCandidate() {
        return this.autowireCandidate;
    }

    @Override
    public void setAutowireCandidate(boolean candidate) {
        this.autowireCandidate = candidate;
    }

    public void toString(JBossStringBuilder buffer) {
        Set<DependencyItem> iDependOn = this.iDependOn;
        if (iDependOn != null) {
            buffer.append("idependOn=").append(iDependOn);
        }
        try {
            Set<DependencyItem> unresolved = this.getUnresolvedDependencies(null);
            if (!unresolved.isEmpty()) {
                buffer.append(" unresolved=").append(unresolved);
            }
        }
        catch (Throwable ignored) {
            buffer.append(" unresolved=" + ignored);
        }
    }
}

