/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.dependency.plugins;

import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.ControllerStateModel;

/**
 * Abstract controller state model.
 *
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public abstract class AbstractControllerStateModel implements ControllerStateModel
{
   /**
    * Add a state to the model. This should be initiated via Controller.addState()
    * 
    * @param state The state to add
    * @param before The exisiting state to add this state before
    * @return true if the state was added, false if the state already existed and therefore was not added
    * @throws IllegalArgumentException if the before state did not exist
    */
   public abstract boolean addState(ControllerState state, ControllerState before);
   
   /**
    * Do any special work needed for the state model to index the state as an optimization
    * 
    * @param state The state to index
    * @return the indexed state
    */
   public abstract ControllerState indexState(ControllerState state);
}
