/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.microcontainer.jmx;

import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.MetaData;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ServiceController;

@Deprecated
public class ServiceControllerLifecycleCallback {
    private static final Logger log = Logger.getLogger(ServiceControllerLifecycleCallback.class);
    private ServiceController serviceController;
    private static ObjectName MBEAN_REGISTRY = ObjectNameFactory.create((String)"JMImplementation:type=MBeanRegistry");

    public ServiceController getServiceController() {
        return this.serviceController;
    }

    public void setServiceController(ServiceController serviceController) {
        this.serviceController = serviceController;
    }

    public void create() throws Exception {
        if (this.serviceController == null) {
            throw new IllegalStateException("No service controller configured");
        }
    }

    public void install(ControllerContext context) throws Exception {
        JMX jmx = this.readJmxAnnotation(context);
        ObjectName objectName = this.createObjectName(context, jmx);
        Class intfClass = null;
        boolean registerDirectly = false;
        if (jmx != null) {
            intfClass = jmx.exposedInterface();
            registerDirectly = jmx.registerDirectly();
        }
        Object mbean = registerDirectly ? context.getTarget() : new StandardMBean(context.getTarget(), intfClass);
        MBeanServer server = this.serviceController.getMBeanServer();
        ClassLoader cl = null;
        if (context instanceof InvokeDispatchContext) {
            try {
                cl = ((InvokeDispatchContext)context).getClassLoader();
            }
            catch (Throwable t) {
                log.debugf("Unable to get classloader from %1s" + context + " %2s", new Object[]{context, t});
            }
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
        }
        ObjectName classLoaderName = null;
        while (cl != null) {
            if (cl instanceof RealClassLoader) {
                classLoaderName = ((RealClassLoader)cl).getObjectName();
                break;
            }
            cl = cl.getParent();
        }
        if (classLoaderName != null) {
            HashMap<String, ClassLoader> valueMap = new HashMap<String, ClassLoader>();
            valueMap.put("org.jboss.mx.classloader", cl);
            Object[] args = new Object[]{mbean, objectName, valueMap};
            String[] sig = new String[]{Object.class.getName(), ObjectName.class.getName(), Map.class.getName()};
            server.invoke(MBEAN_REGISTRY, "registerMBean", args, sig);
        } else {
            server.registerMBean(mbean, objectName);
        }
        try {
            this.serviceController.start(objectName);
        }
        catch (Exception e) {
            try {
                server.unregisterMBean(objectName);
            }
            catch (Exception t) {
                log.debugf((Throwable)t, "Error unregistering mbean", new Object[0]);
            }
            throw e;
        }
        log.debugf("Registered MBean %1s", new Object[]{objectName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall(ControllerContext context) throws Exception {
        JMX jmx = this.readJmxAnnotation(context);
        ObjectName objectName = this.createObjectName(context, jmx);
        try {
            log.debugf("Unregistering MBean %1s", new Object[]{objectName});
            this.serviceController.destroy(objectName);
        }
        finally {
            try {
                this.serviceController.remove(objectName);
            }
            catch (Exception e) {
                log.debugf((Throwable)e, "Error unregistering mbean", new Object[0]);
            }
        }
        log.debugf("Unregistered MBean %1s", new Object[]{objectName});
    }

    private JMX readJmxAnnotation(ControllerContext context) throws Exception {
        MetaData metaData = context.getScopeInfo().getMetaData();
        if (metaData != null) {
            return (JMX)metaData.getAnnotation(JMX.class);
        }
        return null;
    }

    private ObjectName createObjectName(ControllerContext context, JMX jmx) throws Exception {
        String jmxName;
        ObjectName objectName = null;
        if (jmx != null && (jmxName = jmx.name()) != null && jmxName.length() > 0) {
            objectName = new ObjectName(jmxName);
        }
        if (objectName == null) {
            String name = (String)context.getName();
            objectName = name.contains(":") ? new ObjectName(name) : new ObjectName("test:name='" + name + "'");
        }
        return objectName;
    }
}

