/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.system.ListenerServiceMBean;
import org.jboss.system.NotificationFilterFactory;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListenerServiceMBeanSupport
extends ServiceMBeanSupport
implements ListenerServiceMBean,
NotificationListener {
    private List sublist;
    private Element xmllist;
    private boolean dynamicSubscriptions;
    private ObjectName listener;
    private Object myHandback;
    private NotificationFilterSupport myFilter;
    private boolean subscribed;

    public ListenerServiceMBeanSupport() {
        this.init();
    }

    public ListenerServiceMBeanSupport(Class type) {
        super(type);
        this.init();
    }

    public ListenerServiceMBeanSupport(String category) {
        super(category);
        this.init();
    }

    public ListenerServiceMBeanSupport(Logger log) {
        super(log);
        this.init();
    }

    @Override
    public void setSubscriptionList(Element list) {
        this.xmllist = (Element)list.cloneNode(true);
    }

    public List<SubscriptionInfo> getSubscriptions() {
        return this.sublist;
    }

    public void setSubscriptions(List<SubscriptionInfo> list) {
        this.sublist = list;
    }

    public void subscribe(boolean dynamicSubscriptions) throws Exception {
        this.subscribe(dynamicSubscriptions, this.getServiceName());
    }

    public void subscribe(boolean dynamicSubscriptions, ObjectName listener) throws Exception {
        if (this.xmllist != null && this.sublist == null) {
            this.log.debugf("Parsing subscription specification", new Object[0]);
            ArrayList subscriptionList = this.parseXMLSubscriptionSpec(this.xmllist);
            this.subscribe(subscriptionList, dynamicSubscriptions, listener);
        } else if (this.sublist != null) {
            this.subscribe(this.sublist, dynamicSubscriptions, listener);
        } else {
            this.log.debugf("Subscription specification not provided", new Object[0]);
        }
    }

    public void subscribe(List subscriptionList, boolean dynamicSubscriptions, ObjectName listener) throws Exception {
        if (this.subscribed) {
            return;
        }
        if (subscriptionList != null) {
            this.sublist = subscriptionList;
            this.dynamicSubscriptions = dynamicSubscriptions;
            this.listener = listener;
            this.log.debugf("%1s", new Object[]{this.sublist});
            this.log.debugf("Subscribing for JMX notifications, dynamic=%1s %2s", new Object[]{dynamicSubscriptions, this.getServiceName().equals(listener) ? "" : ", listener='" + listener + "'"});
            this.bulkRegister();
            if (dynamicSubscriptions) {
                this.getServer().addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this.getServiceName(), (NotificationFilter)this.myFilter, this.myHandback);
                this.log.debugf("Subscribed to MBeanServerDelegate, too", new Object[0]);
            }
            this.subscribed = true;
        } else {
            this.log.debugf("Subscription list not provided", new Object[0]);
        }
    }

    public void unsubscribe() {
        if (!this.subscribed) {
            return;
        }
        this.log.debugf("Removing all JMX notification subscriptions", new Object[0]);
        this.bulkUnregister();
        if (this.dynamicSubscriptions) {
            try {
                this.getServer().removeNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this.getServiceName(), (NotificationFilter)this.myFilter, this.myHandback);
                this.log.debugf("Unsubscribed from MBeanServerDelegate, too", new Object[0]);
            }
            catch (MalformedObjectNameException e) {
                this.log.warn((Object)"Could not convert 'JMImplementation:type=MBeanServerDelegate' to ObjectName", (Throwable)e);
            }
            catch (InstanceNotFoundException e) {
                this.log.warn((Object)"Could not unsubscribe from non-existent MBeanServerDelegate!", (Throwable)e);
            }
            catch (ListenerNotFoundException e) {
                this.log.warn((Object)"Could not unsubscribe from MBeanServerDelegate", (Throwable)e);
            }
        }
        this.subscribed = false;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (this.dynamicSubscriptions && handback == this.myHandback) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("It's for me: " + notification + ", handback:" + handback));
            }
            String type = notification.getType();
            ObjectName target = null;
            try {
                target = ((MBeanServerNotification)notification).getMBeanName();
            }
            catch (ClassCastException e) {
                this.log.warn((Object)("MBeanServer sent unknown notification class type: " + notification.getClass().getName()));
                return;
            }
            if (type.equals("JMX.mbean.registered")) {
                for (SubscriptionInfo mbeanInfo : this.sublist) {
                    ObjectName objectName = mbeanInfo.getObjectName();
                    try {
                        if (!objectName.apply(target)) continue;
                        this.log.debugf("ObjectName: '%1s' matched '%2s'", new Object[]{target, objectName});
                        this.singleRegister(this.getServer(), target, this.listener, mbeanInfo.getFilter(), mbeanInfo.getHandback());
                    }
                    catch (Exception e) {
                        this.log.warn((Object)("Caught exception from ObjectName.apply(" + target + ")"), (Throwable)e);
                    }
                }
            } else {
                this.log.warn((Object)("Got unknown notification type from MBeanServerDelegate: " + type));
            }
        } else {
            this.handleNotification2(notification, handback);
        }
    }

    public void handleNotification2(Notification notification, Object handback) {
    }

    private void init() {
        this.myHandback = Integer.MAX_VALUE;
        this.myFilter = new NotificationFilterSupport();
        this.myFilter.enableType("JMX.mbean.registered");
    }

    private void singleRegister(MBeanServer server, ObjectName target, ObjectName listener, NotificationFilter filter, Object handback) {
        try {
            server.addNotificationListener(target, listener, filter, handback);
            this.logSubscription(target, listener, handback, filter);
        }
        catch (InstanceNotFoundException e) {
            this.log.debugf("Could not subscribe to: '%1s', target or listener MBean not registered", new Object[]{target});
        }
        catch (RuntimeException e) {
            this.log.warn((Object)("Failed to subscribe to: '" + target + "', maybe not a notification broadcaster or: '" + listener + "', maybe not a notification listener"));
        }
    }

    private void singleUnregister(MBeanServer server, ObjectName target, ObjectName listener, NotificationFilter filter, Object handback) {
        try {
            server.removeNotificationListener(target, listener, filter, handback);
            this.log.debugf("Unsubscribed from: '%1s'", new Object[]{target});
        }
        catch (InstanceNotFoundException e) {
            this.log.debugf("Could not unsubscribe from non-existent: '%1s'", new Object[]{target});
        }
        catch (ListenerNotFoundException e) {
            this.log.debugf("Could not unsubscribe from: '%1s'", new Object[]{target});
        }
        catch (RuntimeException e) {
            this.log.debugf("Could not unsubscribe from: '%1s'", new Object[]{target});
        }
    }

    private void bulkRegister() {
        Iterator i = this.sublist.iterator();
        MBeanServer server = this.getServer();
        while (i.hasNext()) {
            SubscriptionInfo mbeanInfo = (SubscriptionInfo)i.next();
            ObjectName objectName = mbeanInfo.getObjectName();
            Object handback = mbeanInfo.getHandback();
            NotificationFilter filter = mbeanInfo.getFilter();
            if (objectName.isPattern()) {
                Set<ObjectName> mset = server.queryNames(objectName, null);
                this.log.debugf("ObjectName: '%1s' matched %2d MBean(s)", new Object[]{objectName, mset.size()});
                Iterator<ObjectName> j = mset.iterator();
                while (j.hasNext()) {
                    this.singleRegister(server, j.next(), this.listener, filter, handback);
                }
                continue;
            }
            this.singleRegister(server, objectName, this.listener, filter, handback);
        }
    }

    private void bulkUnregister() {
        Iterator i = this.sublist.iterator();
        MBeanServer server = this.getServer();
        while (i.hasNext()) {
            SubscriptionInfo mbeanInfo = (SubscriptionInfo)i.next();
            ObjectName objectName = mbeanInfo.getObjectName();
            Object handback = mbeanInfo.getHandback();
            NotificationFilter filter = mbeanInfo.getFilter();
            if (objectName.isPattern()) {
                Set<ObjectName> mset = server.queryNames(objectName, null);
                this.log.debugf("ObjectName: '%1s' matched %2d MBean(s)", new Object[]{objectName, mset.size()});
                Iterator<ObjectName> j = mset.iterator();
                while (j.hasNext()) {
                    this.singleUnregister(server, j.next(), this.listener, filter, handback);
                }
                continue;
            }
            this.singleUnregister(server, objectName, this.listener, filter, handback);
        }
    }

    private void logSubscription(ObjectName objectName, ObjectName listener, Object handback, NotificationFilter filter) {
        StringBuffer sbuf = new StringBuffer(100);
        sbuf.append("Subscribed to: { objectName='%1s");
        sbuf.append("', listener='%2s");
        sbuf.append("', handback=%3s");
        sbuf.append(", filter=%4s");
        sbuf.append(" }");
        this.log.debugf(sbuf.toString(), new Object[]{objectName, listener, handback, filter});
    }

    private NotificationFilter createNotificationFilter(String factoryClass, Element filterConfig) throws Exception {
        NotificationFilterFactory factory;
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(factoryClass);
            factory = (NotificationFilterFactory)clazz.newInstance();
        }
        catch (Exception e) {
            try {
                factoryClass = "org.jboss.system.filterfactory." + factoryClass;
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(factoryClass);
                factory = (NotificationFilterFactory)clazz.newInstance();
            }
            catch (Exception inner) {
                throw e;
            }
        }
        return factory.createNotificationFilter(filterConfig);
    }

    private ArrayList parseXMLSubscriptionSpec(Element root) throws Exception {
        ArrayList<SubscriptionInfo> slist = new ArrayList<SubscriptionInfo>();
        if (!root.getNodeName().equals("subscription-list")) {
            throw new Exception("Expected 'subscription-list' element, got: '" + root.getNodeName() + "'");
        }
        NodeList rootlist = root.getChildNodes();
        for (int i = 0; i < rootlist.getLength(); ++i) {
            Node mbean = rootlist.item(i);
            if (!mbean.getNodeName().equals("mbean")) continue;
            String name = null;
            if (!((Element)mbean).hasAttribute("name")) {
                throw new Exception("'mbean' element must have a 'name' attribute");
            }
            name = ((Element)mbean).getAttribute("name");
            String handback = null;
            if (((Element)mbean).hasAttribute("handback")) {
                handback = ((Element)mbean).getAttribute("handback");
            }
            ObjectName objectName = new ObjectName(name);
            NotificationFilter filter = null;
            NodeList mbeanChildren = mbean.getChildNodes();
            for (int j = 0; j < mbeanChildren.getLength(); ++j) {
                Node mbeanChildNode = mbeanChildren.item(j);
                if (!mbeanChildNode.getNodeName().equals("filter")) continue;
                String factory = null;
                if (((Element)mbeanChildNode).hasAttribute("factory")) {
                    factory = ((Element)mbeanChildNode).getAttribute("factory");
                    filter = this.createNotificationFilter(factory, (Element)mbeanChildNode);
                    break;
                }
                throw new Exception("'filter' element must have a 'factory' attribute");
            }
            if (filter == null) {
                ArrayList<String> tmplist = new ArrayList<String>(mbeanChildren.getLength());
                for (int j = 0; j < mbeanChildren.getLength(); ++j) {
                    Node mbeanChildNode = mbeanChildren.item(j);
                    if (!mbeanChildNode.getNodeName().equals("notification")) continue;
                    String type = null;
                    if (((Element)mbeanChildNode).hasAttribute("type")) {
                        type = ((Element)mbeanChildNode).getAttribute("type");
                        tmplist.add(type);
                        continue;
                    }
                    throw new Exception("'notification' element must have a 'type' attribute");
                }
                if (tmplist.size() > 0) {
                    NotificationFilterSupport sfilter = new NotificationFilterSupport();
                    for (int j = 0; j < tmplist.size(); ++j) {
                        sfilter.enableType((String)tmplist.get(j));
                    }
                    filter = sfilter;
                }
            }
            slist.add(new SubscriptionInfo(objectName, handback, filter));
        }
        return slist;
    }

    public static final class SubscriptionInfo {
        private ObjectName objectName;
        private Object handback;
        private NotificationFilter filter;

        public SubscriptionInfo(ObjectName objectName, Object handback, NotificationFilter filter) {
            this.objectName = objectName;
            this.handback = handback;
            this.filter = filter;
        }

        public ObjectName getObjectName() {
            return this.objectName;
        }

        public Object getHandback() {
            return this.handback;
        }

        public NotificationFilter getFilter() {
            return this.filter;
        }

        public String toString() {
            StringBuffer sbuf = new StringBuffer(100);
            sbuf.append("SubscriptionInfo { objectName='").append(this.objectName);
            sbuf.append("', handback=").append(this.handback);
            sbuf.append(", filter=");
            sbuf.append(this.filter == null ? null : this.filter.toString());
            sbuf.append(" }");
            return sbuf.toString();
        }
    }
}

