/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import javax.management.AttributeChangeNotification;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.beans.metadata.api.annotations.Create;
import org.jboss.beans.metadata.api.annotations.Destroy;
import org.jboss.beans.metadata.api.annotations.Start;
import org.jboss.beans.metadata.api.annotations.Stop;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.logging.Logger;
import org.jboss.mx.util.JBossNotificationBroadcasterSupport;
import org.jboss.system.ServiceController;
import org.jboss.system.ServiceMBean;
import org.jboss.util.Classes;

public class ServiceMBeanSupport
extends JBossNotificationBroadcasterSupport
implements ServiceMBean,
MBeanRegistration,
KernelControllerContextAware {
    public static final String[] SERVICE_CONTROLLER_SIG = new String[]{ObjectName.class.getName()};
    protected Logger log;
    protected MBeanServer server;
    protected ObjectName serviceName;
    private int state = 7;
    private boolean isJBossInternalLifecycleExposed = false;
    private KernelControllerContext controllerContext;

    public ServiceMBeanSupport() {
        this.log = Logger.getLogger((String)this.getClass().getName());
        this.log.trace((Object)"Constructing");
    }

    public ServiceMBeanSupport(Class type) {
        this(type.getName());
    }

    public ServiceMBeanSupport(String category) {
        this(Logger.getLogger((String)category));
    }

    public ServiceMBeanSupport(Logger log) {
        this.log = log;
        log.trace((Object)"Constructing");
    }

    public void setKernelControllerContext(KernelControllerContext controllerContext) throws Exception {
        this.controllerContext = controllerContext;
    }

    public void unsetKernelControllerContext(KernelControllerContext controllerContext) throws Exception {
        this.controllerContext = null;
    }

    public String getName() {
        return Classes.stripPackageName((String)this.log.getName());
    }

    public ObjectName getServiceName() {
        return this.serviceName;
    }

    public MBeanServer getServer() {
        return this.server;
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        return states[this.state];
    }

    public Logger getLog() {
        return this.log;
    }

    @Create
    public void pojoCreate() throws Exception {
        this.jbossInternalCreate();
    }

    @Start
    public void pojoStart() throws Exception {
        this.jbossInternalStart();
    }

    @Stop
    public void pojoStop() throws Exception {
        this.jbossInternalStop();
    }

    @Destroy
    public void pojoDestroy() throws Exception {
        this.jbossInternalDestroy();
    }

    protected void pojoChange(ControllerState state) {
        Controller controller = this.controllerContext.getController();
        try {
            controller.change((ControllerContext)this.controllerContext, state);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error changing state of " + this.controllerContext.getName() + " to " + state.getStateString(), t);
        }
    }

    public void create() throws Exception {
        if (this.controllerContext != null) {
            this.pojoChange(ControllerState.CREATE);
        } else if (this.serviceName != null && this.isJBossInternalLifecycleExposed) {
            this.server.invoke(ServiceController.OBJECT_NAME, "create", new Object[]{this.serviceName}, SERVICE_CONTROLLER_SIG);
        } else {
            this.jbossInternalCreate();
        }
    }

    public void start() throws Exception {
        if (this.controllerContext != null) {
            this.pojoChange(ControllerState.START);
        } else if (this.serviceName != null && this.isJBossInternalLifecycleExposed) {
            this.server.invoke(ServiceController.OBJECT_NAME, "start", new Object[]{this.serviceName}, SERVICE_CONTROLLER_SIG);
        } else {
            this.jbossInternalStart();
        }
    }

    public void stop() {
        try {
            if (this.controllerContext != null) {
                this.pojoChange(ControllerState.CREATE);
            } else if (this.serviceName != null && this.isJBossInternalLifecycleExposed) {
                this.server.invoke(ServiceController.OBJECT_NAME, "stop", new Object[]{this.serviceName}, SERVICE_CONTROLLER_SIG);
            } else {
                this.jbossInternalStop();
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error in stop " + this.jbossInternalDescription()), t);
        }
    }

    public void destroy() {
        try {
            if (this.controllerContext != null) {
                this.pojoChange(ControllerState.CONFIGURED);
            } else if (this.serviceName != null && this.isJBossInternalLifecycleExposed) {
                this.server.invoke(ServiceController.OBJECT_NAME, "destroy", new Object[]{this.serviceName}, SERVICE_CONTROLLER_SIG);
            } else {
                this.jbossInternalDestroy();
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error in destroy " + this.jbossInternalDescription()), t);
        }
    }

    protected String jbossInternalDescription() {
        if (this.serviceName != null) {
            return this.serviceName.toString();
        }
        return this.getName();
    }

    public void jbossInternalLifecycle(String method) throws Exception {
        if (method == null) {
            throw new IllegalArgumentException("Null method name");
        }
        if (method.equals("create")) {
            this.jbossInternalCreate();
        } else if (method.equals("start")) {
            this.jbossInternalStart();
        } else if (method.equals("stop")) {
            this.jbossInternalStop();
        } else if (method.equals("destroy")) {
            this.jbossInternalDestroy();
        } else {
            throw new IllegalArgumentException("Unknown lifecyle method " + method);
        }
    }

    protected void jbossInternalCreate() throws Exception {
        if (this.state == 6 || this.state == 2 || this.state == 3 || this.state == 1 || this.state == 0) {
            this.log.debugf("Ignoring create call; current state is %1s", new Object[]{this.getStateString()});
            return;
        }
        this.log.debugf("Creating %1s", new Object[]{this.jbossInternalDescription()});
        try {
            this.createService();
            this.state = 6;
        }
        catch (Exception e) {
            this.log.debugf((Throwable)e, "Initialization failed %1s", new Object[]{this.jbossInternalDescription()});
            throw e;
        }
        this.log.debugf("Created %1s", new Object[]{this.jbossInternalDescription()});
    }

    protected void jbossInternalStart() throws Exception {
        if (this.state == 2 || this.state == 3 || this.state == 1) {
            this.log.debugf("Ignoring start call; current state is %1s", new Object[]{this.getStateString()});
            return;
        }
        if (this.state != 6 && this.state != 0 && this.state != 4) {
            this.log.debugf("Start requested before create, calling create now", new Object[0]);
            this.create();
        }
        this.state = 2;
        this.sendStateChangeNotification(0, 2, this.getName() + " starting", null);
        this.log.debugf("Starting %1s", new Object[]{this.jbossInternalDescription()});
        try {
            this.startService();
        }
        catch (Exception e) {
            this.state = 4;
            this.sendStateChangeNotification(2, 4, this.getName() + " failed", e);
            this.log.debugf((Throwable)e, "Starting failed %1s", new Object[]{this.jbossInternalDescription()});
            throw e;
        }
        this.state = 3;
        this.sendStateChangeNotification(2, 3, this.getName() + " started", null);
        this.log.debugf("Started %1s", new Object[]{this.jbossInternalDescription()});
    }

    protected void jbossInternalStop() {
        if (this.state != 3) {
            this.log.debugf("Ignoring stop call; current state is %1s", new Object[]{this.getStateString()});
            return;
        }
        this.state = 1;
        this.sendStateChangeNotification(3, 1, this.getName() + " stopping", null);
        this.log.debugf("Stopping %1s", new Object[]{this.jbossInternalDescription()});
        try {
            this.stopService();
        }
        catch (Throwable e) {
            this.state = 4;
            this.sendStateChangeNotification(1, 4, this.getName() + " failed", e);
            this.log.warn((Object)("Stopping failed " + this.jbossInternalDescription()), e);
            return;
        }
        this.state = 0;
        this.sendStateChangeNotification(1, 0, this.getName() + " stopped", null);
        this.log.debugf("Stopped %1s", new Object[]{this.jbossInternalDescription()});
    }

    protected void jbossInternalDestroy() {
        if (this.state == 5) {
            this.log.debugf("Ignoring destroy call; current state is %1s", new Object[]{this.getStateString()});
            return;
        }
        if (this.state == 3) {
            this.log.debugf("Destroy requested before stop, calling stop now", new Object[0]);
            this.stop();
        }
        this.log.debugf("Destroying %1s", new Object[]{this.jbossInternalDescription()});
        try {
            this.destroyService();
        }
        catch (Throwable t) {
            this.log.warn((Object)("Destroying failed " + this.jbossInternalDescription()), t);
        }
        this.state = 5;
        this.log.debugf("Destroyed %1s", new Object[]{this.jbossInternalDescription()});
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.serviceName = this.getObjectName(server, name);
        return this.serviceName;
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            this.log.info((Object)"Registration is not done -> stop");
            this.stop();
        } else {
            this.state = 8;
            try {
                MBeanInfo info = this.server.getMBeanInfo(this.serviceName);
                MBeanOperationInfo[] ops = info.getOperations();
                for (int i = 0; i < ops.length; ++i) {
                    if (ops[i] == null || !"jbossInternalLifecycle".equals(ops[i].getName())) continue;
                    this.isJBossInternalLifecycleExposed = true;
                    break;
                }
            }
            catch (Throwable t) {
                this.log.warn((Object)("Unexcepted error accessing MBeanInfo for " + this.serviceName), t);
            }
        }
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.server = null;
        this.serviceName = null;
        this.state = 7;
    }

    protected long getNextNotificationSequenceNumber() {
        return this.nextNotificationSequenceNumber();
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name;
    }

    protected void createService() throws Exception {
    }

    protected void startService() throws Exception {
    }

    protected void stopService() throws Exception {
    }

    protected void destroyService() throws Exception {
    }

    private void sendStateChangeNotification(int oldState, int newState, String msg, Throwable t) {
        long now = System.currentTimeMillis();
        AttributeChangeNotification stateChangeNotification = new AttributeChangeNotification(this, this.getNextNotificationSequenceNumber(), now, msg, "State", "java.lang.Integer", oldState, newState);
        stateChangeNotification.setUserData(t);
        this.sendNotification(stateChangeNotification);
    }
}

