/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.system.microcontainer;

import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.system.ServiceController;

/**
 * DescribeAction.
 * Populate MDR with context info.
 * Called when installing to/uninstalling from the
 * {@link ControllerState#DESCRIBED} state.
 * 
 * @see ServiceControllerContextActions
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @author <a href="ales.justin@jboss.org">Ales Justin</a>
 * @version $Revision: 100669 $
 */
public class DescribeAction extends ServiceControllerContextAction
{
   /**
    * Get kernel metadata repository.
    *
    * @param context the service controller context
    * @return kernel metadata reposiory
    */
   protected KernelMetaDataRepository getRepository(ServiceControllerContext context)
   {
      ServiceController controller = context.getServiceController();
      Kernel kernel = controller.getKernel();
      return kernel.getMetaDataRepository();
   }

   /**
    * Push context to MDR.
    * 
    * @param context The ServiceControllerContext we are installing
    */
   public void installAction(ServiceControllerContext context) throws Throwable
   {
      KernelMetaDataRepository repository = getRepository(context);
      repository.addMetaData(context);
   }

   /**
    * Remove context form MDR.
    * 
    * @param context The ServiceControllerContext we are uninstalling
    */
   public void uninstallAction(ServiceControllerContext context)
   {
      KernelMetaDataRepository repository = getRepository(context);
      repository.removeMetaData(context);
   }
}
