/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.kernel.plugins.dependency;

import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.plugins.helpers.StatelessController;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.event.KernelEvent;
import org.jboss.kernel.spi.event.KernelEventFilter;
import org.jboss.kernel.spi.event.KernelEventListener;

/**
 * Stateless kernel controller.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class StatelessKernelController extends StatelessController implements KernelController
{
   private KernelController delegate;

   public StatelessKernelController(KernelController controller)
   {
      super(controller);
      this.delegate = controller;
   }

   public KernelControllerContext install(BeanMetaData metaData) throws Throwable
   {
      return delegate.install(metaData);
   }

   public KernelControllerContext install(BeanMetaData metaData, Object target) throws Throwable
   {
      return delegate.install(metaData, target);
   }

   public void addSupplies(KernelControllerContext context)
   {
   }

   public void removeSupplies(KernelControllerContext context)
   {
   }

   public Kernel getKernel()
   {
      return delegate.getKernel();
   }

   public void setKernel(Kernel kernel) throws Throwable
   {
   }

   public void registerListener(KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable
   {
      delegate.registerListener(listener, filter, handback);
   }

   public void unregisterListener(KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable
   {
      delegate.unregisterListener(listener, filter, handback);
   }

   public void fireKernelEvent(KernelEvent event)
   {
      delegate.fireKernelEvent(event);
   }
}
