/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.kernel.plugins.annotations;

import java.util.List;

import javax.inject.Inject;

import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.metadata.spi.MetaData;
import org.jboss.reflect.spi.FieldInfo;

/**
 * Value factory field annotation plugin.
 *
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
public class Jsr330InjectFieldAnnotationPlugin extends FieldAnnotationPlugin<Inject>
{
   public static final Jsr330InjectFieldAnnotationPlugin INSTANCE = new Jsr330InjectFieldAnnotationPlugin();

   protected Jsr330InjectFieldAnnotationPlugin()
   {
      super(Inject.class);
   }


   @Override
   protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(FieldInfo info, MetaData retrieval, Inject annotation, BeanMetaData beanMetaData) throws Throwable
   {
       if (!Jsr330InjectFilter.INSTANCE.handleInject(retrieval))
          return null;
      
       return super.internalApplyAnnotation(info, retrieval, annotation, beanMetaData);
   }

   @Override
   public ValueMetaData createValueMetaData(Inject annotation)
   {
      return new AbstractInjectionValueMetaData();
   }
}
