/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.SecurityPermission;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.AliasMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.dependency.plugins.AbstractControllerContext;
import org.jboss.dependency.plugins.AbstractDependencyInfo;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.ControllerStateModel;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.dependency.spi.ErrorHandlingMode;
import org.jboss.dependency.spi.ScopeInfo;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.plugins.dependency.BeanValidatorBridge;
import org.jboss.kernel.plugins.dependency.ClearableDependencyItem;
import org.jboss.kernel.plugins.dependency.DescribedMetaDataVisitor;
import org.jboss.kernel.plugins.dependency.KernelControllerContextAction;
import org.jboss.kernel.plugins.dependency.KernelControllerContextActions;
import org.jboss.kernel.plugins.dependency.KernelScopeInfo;
import org.jboss.kernel.plugins.dependency.PreprocessMetaDataVisitor;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractKernelControllerContext
extends AbstractControllerContext
implements KernelControllerContext {
    private static final KernelControllerContextActions actions = KernelControllerContextActions.getInstance();
    private static final KernelControllerContextActions noInstantiate = KernelControllerContextActions.getNoInstantiate();
    private static final RuntimePermission GET_CLASSLOADER_PERMISSION = new RuntimePermission("getClassLoader");
    private static final SecurityPermission GET_ACCESS_CONTROL_CONTEXT_PERMISSION = new SecurityPermission("getAccessControlContext");
    private BeanInfo info;
    private BeanMetaData metaData;
    private AccessControlContext accessContext;
    private boolean isInitialProcessed;
    private boolean isDescribeProcessed;

    private static Set<Object> determineAliases(BeanMetaData metaData) {
        AbstractBeanMetaData abmd;
        Set<AliasMetaData> aliasMetaDatas;
        if (metaData == null) {
            return null;
        }
        if (metaData instanceof AbstractBeanMetaData && (aliasMetaDatas = (abmd = (AbstractBeanMetaData)metaData).getAliasMetaData()) != null && !aliasMetaDatas.isEmpty()) {
            Set<Object> aliases = abmd.getAliases();
            if (aliases == null) {
                aliases = new HashSet<Object>();
                abmd.setAliases(aliases);
            }
            for (AliasMetaData aliasMetaData : aliasMetaDatas) {
                aliases.add(aliasMetaData.getAliasValue());
            }
        }
        return metaData.getAliases();
    }

    public AbstractKernelControllerContext(BeanInfo info, BeanMetaData metaData, Object target) {
        this(info, metaData, target == null ? actions : noInstantiate, target);
    }

    protected AbstractKernelControllerContext(BeanInfo info, BeanMetaData metaData, KernelControllerContextActions actions, Object target) {
        super((Object)metaData.getName(), AbstractKernelControllerContext.determineAliases(metaData), (ControllerContextActions)actions, (DependencyInfo)new AbstractDependencyInfo(), target);
        ErrorHandlingMode errorHandlingMode;
        this.info = info;
        this.metaData = metaData;
        ControllerMode mode = metaData.getMode();
        if (mode != null) {
            this.setMode(mode);
        }
        if ((errorHandlingMode = metaData.getErrorHandlingMode()) != null) {
            this.setErrorHandlingMode(errorHandlingMode);
        }
        boolean autowireCandidate = metaData.isAutowireCandidate();
        this.getDependencyInfo().setAutowireCandidate(autowireCandidate);
        if (System.getSecurityManager() != null) {
            this.accessContext = AccessController.getContext();
        }
        this.initKernelScopeInfo();
    }

    @Override
    public Kernel getKernel() {
        KernelController controller = (KernelController)this.getController();
        if (controller == null) {
            throw new IllegalStateException("Context is not installed in controller");
        }
        return controller.getKernel();
    }

    @Override
    public BeanInfo getBeanInfo() {
        return this.info;
    }

    @Override
    public void setBeanInfo(BeanInfo info) {
        this.info = info;
        this.infoprocessMetaData();
        this.flushJBossObjectCache();
    }

    @Override
    public BeanMetaData getBeanMetaData() {
        return this.metaData;
    }

    public void toString(JBossStringBuilder buffer) {
        if (this.metaData != null) {
            buffer.append(" metadata=").append((Object)this.metaData);
        }
        super.toString(buffer);
    }

    public void setController(Controller controller) {
        super.setController(controller);
        this.preprocessMetaData();
    }

    protected void initScopeInfo() {
    }

    protected void initKernelScopeInfo() {
        String bean;
        BeanMetaData bmd;
        String className = null;
        Object target = this.getTarget();
        if (target != null) {
            className = target.getClass().getName();
        }
        if ((bmd = this.getBeanMetaData()) != null && (bean = bmd.getBean()) != null) {
            className = bean;
        }
        this.setScopeInfo((ScopeInfo)new KernelScopeInfo(this.getName(), className, bmd));
    }

    protected void preprocessMetaData() {
        if (this.metaData == null) {
            return;
        }
        if (this.isInitialProcessed) {
            return;
        }
        PreprocessMetaDataVisitor visitor = new PreprocessMetaDataVisitor(this.metaData, this);
        AccessController.doPrivileged(visitor);
        this.isInitialProcessed = true;
    }

    protected void infoprocessMetaData() {
        if (this.info == null) {
            this.removeClassContextReference();
            return;
        }
        if (this.isDescribeProcessed) {
            return;
        }
        DescribedMetaDataVisitor visitor = new DescribedMetaDataVisitor(this.metaData, this);
        AccessController.doPrivileged(visitor);
        this.isDescribeProcessed = true;
    }

    public AccessControlContext getAccessControlContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_ACCESS_CONTROL_CONTEXT_PERMISSION);
        }
        return this.accessContext;
    }

    private void removeClassContextReference() {
        DependencyInfo dependencyInfo = this.getDependencyInfo();
        if (dependencyInfo != null) {
            Set dependencys = dependencyInfo.getIDependOn(ClearableDependencyItem.class);
            dependencys.addAll(dependencyInfo.getIDependOn(ClearableDependencyItem.class));
            for (DependencyItem di : dependencys) {
                ClearableDependencyItem cdi = (ClearableDependencyItem)di;
                cdi.clear(this.getController());
            }
        }
    }

    protected BeanInfo getInfo() {
        if (this.info == null) {
            throw new IllegalArgumentException("Null BeanInfo");
        }
        return this.info;
    }

    public Object get(String name) throws Throwable {
        return this.getInfo().getProperty(this.getTarget(), name);
    }

    public void set(String name, Object value) throws Throwable {
        this.getInfo().setProperty(this.getTarget(), name, value);
    }

    public Object invoke(String name, Object[] parameters, String[] signature) throws Throwable {
        this.validateMethodValues(name, signature, parameters);
        return this.getInfo().invoke(this.getTarget(), name, signature, parameters);
    }

    public ClassLoader getClassLoader() throws Throwable {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CLASSLOADER_PERMISSION);
        }
        return Configurator.getClassLoader(this.getBeanMetaData());
    }

    public ControllerState lifecycleInvocation(String name, Object[] parameters, String[] signature) throws Throwable {
        if (AbstractKernelControllerContext.useLifecycleState(name, signature, this.metaData.getCreate(), "create")) {
            ControllerStateModel model = this.getController().getStates();
            if (model.isAfterState(ControllerState.CREATE, this.getState())) {
                return ControllerState.CREATE;
            }
            return this.getState();
        }
        if (AbstractKernelControllerContext.useLifecycleState(name, signature, this.metaData.getStart(), "start")) {
            ControllerStateModel model = this.getController().getStates();
            if (model.isAfterState(ControllerState.START, this.getState())) {
                return ControllerState.START;
            }
            return this.getState();
        }
        if (AbstractKernelControllerContext.useLifecycleState(name, signature, this.metaData.getStop(), "stop")) {
            ControllerStateModel model = this.getController().getStates();
            if (model.isBeforeState(ControllerState.CREATE, this.getState())) {
                return ControllerState.CREATE;
            }
            return this.getState();
        }
        if (AbstractKernelControllerContext.useLifecycleState(name, signature, this.metaData.getDestroy(), "destroy")) {
            ControllerStateModel model = this.getController().getStates();
            if (model.isBeforeState(ControllerState.CONFIGURED, this.getState())) {
                return ControllerState.CONFIGURED;
            }
            return this.getState();
        }
        return null;
    }

    protected static boolean useLifecycleState(String name, String[] signature, LifecycleMetaData lmd, String defaultName) {
        if (lmd != null) {
            String methodName = lmd.getMethodName();
            if (name.equals(methodName) || methodName == null && name.equals(defaultName)) {
                List<ParameterMetaData> params = lmd.getParameters();
                if (params != null) {
                    if (signature != null && params.size() == signature.length) {
                        int i = 0;
                        for (ParameterMetaData pmd : params) {
                            String type = pmd.getType();
                            if (type != null && signature[i] != null && !type.equals(signature[i])) {
                                return false;
                            }
                            ++i;
                        }
                        return true;
                    }
                } else if (signature == null || signature.length == 0) {
                    return true;
                }
            }
        } else if (defaultName.equals(name) && (signature == null || signature.length == 0)) {
            return true;
        }
        return false;
    }

    protected void validateMethodValues(String name, String[] signature, Object[] paramaters) throws Throwable {
        BeanValidatorBridge bridge = KernelControllerContextAction.getBeanValidatorBridge(this);
        if (bridge != null) {
            MethodInfo methodInfo = Configurator.findMethodInfo((ClassInfo)this.getInfo().getClassInfo(), (String)name, (String[])signature);
            bridge.validateMethodValues(this, this.getTarget(), methodInfo, paramaters);
        }
    }
}

