/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.kernel.weld.spi.annotated;

import javax.enterprise.inject.spi.AnnotatedType;

import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.weld.plugins.annotated.MDRAnnotatedTypeFactoryImpl;
import org.jboss.metadata.spi.MetaData;

/**
 * Singleton used to decorate annotated types to understand MDR metadata 
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public abstract class MDRAnnotatedTypeFactory
{
   private final static MDRAnnotatedTypeFactory INSTANCE = new MDRAnnotatedTypeFactoryImpl();
   
   /**
    * Get the singleton instance
    * 
    * @return the singleton
    */
   public static MDRAnnotatedTypeFactory getInstance()
   {
      return INSTANCE;
   }
   
   /**
    * Decorate an annotated type to understand MDR metadata
    * 
    * @param <T> the type of the delegate
    * @param delegate the type to decorate
    * @param metaData the MDR metadata for the bean for which we want to decorate the type
    * @return the type decorated with MDR metadata
    */
   public abstract <T> AnnotatedType<T> decorateAnnotatedType(AnnotatedType<T> delegate, MetaData metaData);

   /**
    * Decorate an annotated type to understand MDR metadata
    * 
    * @param <T> the type of the delegate
    * @param delegate the type to decorate
    * @param context the Kernel controller context which contains the metadata
    * @return the type decorated with MDR metadata
    */
   public abstract <T> AnnotatedType<T> decorateAnnotatedType(AnnotatedType<T> delegate, KernelControllerContext context);
}
