/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.weld.plugins.annotated;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.kernel.weld.plugins.annotated.MDRAnnotated;
import org.jboss.kernel.weld.plugins.annotated.MDRAnnotatedConstructor;
import org.jboss.kernel.weld.plugins.annotated.MDRAnnotatedField;
import org.jboss.kernel.weld.plugins.annotated.MDRAnnotatedMethod;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MDRAnnotatedType<X>
extends MDRAnnotated
implements AnnotatedType<X> {
    private final Set<AnnotatedConstructor<X>> annotatedConstructors = this.initialiseConstructors();
    private final Set<AnnotatedField<? super X>> annotatedFields = this.initialiseAnnotatedFields();
    private final Set<AnnotatedMethod<? super X>> annotatedMethods = this.initialiseMethods();

    MDRAnnotatedType(AnnotatedType<X> delegate, MetaData metaData) {
        super((Annotated)delegate, metaData);
    }

    private Set<AnnotatedField<? super X>> initialiseAnnotatedFields() {
        if (this.getMetaData() == null) {
            return this.getDelegate().getFields();
        }
        HashSet<AnnotatedField<X>> fields = new HashSet<AnnotatedField<X>>();
        for (AnnotatedField field : this.getDelegate().getFields()) {
            MetaData fieldMetaData = this.getMetaData().getComponentMetaData((Signature)new FieldSignature(field.getJavaMember()));
            fields.add(new MDRAnnotatedField(this, field, fieldMetaData));
        }
        return fields;
    }

    private Set<AnnotatedConstructor<X>> initialiseConstructors() {
        if (this.getMetaData() == null) {
            return this.getDelegate().getConstructors();
        }
        HashSet<AnnotatedConstructor<X>> constructors = new HashSet<AnnotatedConstructor<X>>();
        for (AnnotatedConstructor constructor : this.getDelegate().getConstructors()) {
            MetaData constructorMetaData = this.getMetaData().getComponentMetaData((Signature)new ConstructorSignature(constructor.getJavaMember()));
            constructors.add(new MDRAnnotatedConstructor(this, constructor, constructorMetaData, this.getMetaData()));
        }
        return constructors;
    }

    private Set<AnnotatedMethod<? super X>> initialiseMethods() {
        if (this.getMetaData() == null) {
            return this.getDelegate().getMethods();
        }
        HashSet<AnnotatedMethod<X>> methods = new HashSet<AnnotatedMethod<X>>();
        for (AnnotatedMethod method : this.getDelegate().getMethods()) {
            MetaData MethodMetaData = this.getMetaData().getComponentMetaData((Signature)new MethodSignature(method.getJavaMember()));
            methods.add(new MDRAnnotatedMethod(this, (Annotated)method, MethodMetaData, this.getMetaData()));
        }
        return methods;
    }

    AnnotatedType<X> getDelegate() {
        return (AnnotatedType)super.getDelegate();
    }

    public Set<AnnotatedConstructor<X>> getConstructors() {
        return this.annotatedConstructors;
    }

    public Set<AnnotatedField<? super X>> getFields() {
        return this.annotatedFields;
    }

    public Set<AnnotatedMethod<? super X>> getMethods() {
        return this.annotatedMethods;
    }

    public Class<X> getJavaClass() {
        return this.getDelegate().getJavaClass();
    }

    public String toString() {
        return "MDRAnnotatedType{annotations=" + this.getAnnotations() + "; class " + this.getJavaClass().getName() + "}";
    }
}

