/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.kernel.weld.plugins.annotations;

import org.jboss.kernel.plugins.annotations.AbstractBeanAnnotationAdapter;
import org.jboss.kernel.plugins.annotations.BeanAnnotationAdapter;
import org.jboss.kernel.plugins.annotations.BeanAnnotationAdapterFactory;
import org.jboss.kernel.plugins.annotations.CommonAnnotationAdapter;

/**
 * Adds the WeldEnabledAnnotationPlugin to the BeanAnnotationAdapter
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class WeldEnabledBeanAnnotationPluginInitializer extends AbstractBeanAnnotationAdapter
{
   @SuppressWarnings("unchecked")
   public static void initialize()
   {
      BeanAnnotationAdapter adapter = BeanAnnotationAdapterFactory.getInstance().getBeanAnnotationAdapter();
      if (adapter instanceof CommonAnnotationAdapter)
      {
         CommonAnnotationAdapter common = (CommonAnnotationAdapter)adapter;
         common.addAnnotationPlugin(WeldEnabledAnnotationPlugin.INSTANCE);
      }
      else
      {
         throw new IllegalStateException("Adapter is not an instance of CommonAnnotationAdapter " + adapter);
      }
   }
}
