/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.kernel.weld.plugins.dependency;

import org.jboss.kernel.plugins.dependency.DescribeAction;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.weld.plugins.annotations.WeldEnabledBeanAnnotationPluginInitializer;

/**
 * DescribeAction that looks for weld interaction
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class WeldDescribeAction extends DescribeAction
{
   static
   {
      WeldEnabledBeanAnnotationPluginInitializer.initialize();
   }
   
   @Override
   protected void applyAnnotations(KernelControllerContext context) throws Throwable
   {
      if (context instanceof WeldKernelControllerContext == false)
         throw new IllegalArgumentException("context is not a WabBeansKernelControllerContext");
      
      applyWeldAnnotations((WeldKernelControllerContext)context);
      super.applyAnnotations(context);
   }
   
   protected void applyWeldAnnotations(WeldKernelControllerContext context)
   {
      @SuppressWarnings("unchecked")
      WeldInjector<?> weldInjector = new WeldInjector(context, getClazz(context));
      context.setWeldInjector(weldInjector);
      weldInjector.describe();
      
      
   }
   
   protected Class<?> getClazz(WeldKernelControllerContext context)
   {
      return context.getBeanInfo().getClassInfo().getType();
   }

   @Override
   protected void cleanAnnotations(KernelControllerContext context)
   {
      super.cleanAnnotations(context);
   }

   @Override
   protected void uninstallActionInternal(KernelControllerContext context)
   {
      if (context instanceof WeldKernelControllerContext)
         UnsatisfiedDependencyRegistry.getInstance().removeHungContext((WeldKernelControllerContext)context);
      
      super.uninstallActionInternal(context);
   }
}
