/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.kernel.weld.plugins.dependency;

import java.util.HashMap;
import java.util.Map;

import org.jboss.dependency.plugins.action.ControllerContextAction;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.plugins.dependency.CreateDestroyLifecycleAction;
import org.jboss.kernel.plugins.dependency.KernelControllerContextActions;
import org.jboss.kernel.plugins.dependency.PreInstallAction;
import org.jboss.kernel.plugins.dependency.StartStopLifecycleAction;

/**
 * ControllerContextActions for contexts that need to interact with web beans
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class WeldKernelControllerContextActions extends KernelControllerContextActions
{
   private static final WeldKernelControllerContextActions INSTANCE;
   static
   {
      Map<ControllerState, ControllerContextAction> actions = new HashMap<ControllerState, ControllerContextAction>();
      
      actions.put(ControllerState.PRE_INSTALL, new PreInstallAction());
      actions.put(ControllerState.DESCRIBED, new WeldDescribeAction());
      actions.put(ControllerState.INSTANTIATED, new WeldInstantiateAction());
      actions.put(WeldPostConstructAction.STATE, new WeldPostConstructAction());
      actions.put(ControllerState.CONFIGURED, new WeldConfigureAction());
      actions.put(ControllerState.CREATE, new CreateDestroyLifecycleAction());
      actions.put(WeldPreDestroyAction.STATE, new WeldPreDestroyAction());
      actions.put(ControllerState.START, new StartStopLifecycleAction());
      actions.put(ControllerState.INSTALLED, new WeldInstallAction());
      INSTANCE = new WeldKernelControllerContextActions(actions);
   }
   
   protected WeldKernelControllerContextActions(Map<ControllerState, ControllerContextAction> actions)
   {
      super(actions);
   }
   
   public static WeldKernelControllerContextActions getInstance()
   {
      return INSTANCE;
   }
}
