/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.weld.plugins.dependency;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.DependencyMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.kernel.plugins.dependency.AbstractMetaDataVisitor;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.weld.plugins.dependency.WeldKernelControllerContext;
import org.jboss.kernel.weld.plugins.metadata.WeldDependencyMetaData;
import org.jboss.kernel.weld.spi.annotated.MDRAnnotatedTypeFactory;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldInjector<T> {
    static final Logger log = Logger.getLogger(WeldInjector.class);
    WeldKernelControllerContext context;
    AnnotatedType<T> type;
    private final InjectionTarget<T> it;
    private CreationalContext<T> creationalContext;
    private boolean createInWeld;
    private boolean injectInWeld;

    WeldInjector(WeldKernelControllerContext context, Class<T> clazz) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Null clazz");
        }
        this.context = context;
        this.creationalContext = context.getManager().createCreationalContext(null);
        this.type = this.createMdrDecoratedAnnotatedType(clazz);
        this.it = this.getInjectionTarget(clazz);
    }

    private InjectionTarget<T> getInjectionTarget(Class<T> clazz) {
        return this.context.getManager().createInjectionTarget(this.type);
    }

    boolean createInWeld() {
        return this.createInWeld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void describe() {
        AnnotationMetaDataVisitor annotationsVisitor = new AnnotationMetaDataVisitor((KernelControllerContext)this.context);
        annotationsVisitor.before();
        try {
            if (this.it.getInjectionPoints().size() > 0) {
                this.injectInWeld = true;
                BeanMetaData metaData = this.context.getBeanMetaData();
                for (InjectionPoint injectionPoint : this.it.getInjectionPoints()) {
                    BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((BeanMetaData)metaData);
                    WeldDependencyMetaData dependency = new WeldDependencyMetaData(injectionPoint);
                    if (!this.containsDependency((DependencyMetaData)dependency)) {
                        builder.addDependency((DependencyMetaData)dependency);
                        dependency.describeVisit((MetaDataVisitor)annotationsVisitor);
                        dependency.initialVisit((MetaDataVisitor)annotationsVisitor);
                    }
                    if (!(injectionPoint.getMember() instanceof Constructor)) continue;
                    this.createInWeld = true;
                }
            }
        }
        finally {
            annotationsVisitor.after();
        }
    }

    T instantiate() {
        if (!this.createInWeld) {
            throw new IllegalStateException(this.context.getName() + "  should not be created using web beans");
        }
        Object t = this.it.produce(this.creationalContext);
        return (T)t;
    }

    void inject() {
        if (this.injectInWeld) {
            this.it.inject(this.context.getTarget(), this.creationalContext);
        }
    }

    void unconfigure() {
        if (this.injectInWeld) {
            Object tgt = this.context.getTarget();
            for (InjectionPoint ip : this.it.getInjectionPoints()) {
                if (ip.getMember() instanceof Method) {
                    Method m = (Method)ip.getMember();
                    Object[] params = new Object[m.getParameterTypes().length];
                    try {
                        m.invoke(tgt, params);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Error unsetting values for method " + m.getName() + " in bean " + this.context.getName()), (Throwable)e);
                    }
                    continue;
                }
                if (!(ip.getMember() instanceof Field)) continue;
                Field f = (Field)ip.getMember();
                try {
                    f.set(tgt, null);
                }
                catch (Exception e) {
                    log.warn((Object)("Error unsetting values for field " + f.getName() + " in bean " + this.context.getName()), (Throwable)e);
                }
            }
        }
    }

    void postConstruct(Object instance) {
        if (instance == null) {
            throw new IllegalArgumentException("Null instance");
        }
        this.it.postConstruct(instance);
    }

    void preDestroy(Object instance) {
        if (instance == null) {
            throw new IllegalArgumentException("Null instance");
        }
        this.it.preDestroy(instance);
        this.creationalContext.release();
    }

    private boolean containsDependency(DependencyMetaData dependency) {
        return this.context.getBeanMetaData().getDepends() != null && this.context.getBeanMetaData().getDepends().contains(dependency);
    }

    private AnnotatedType<T> createMdrDecoratedAnnotatedType(Class<T> clazz) {
        AnnotatedType type = this.context.getManager().createAnnotatedType(clazz);
        return MDRAnnotatedTypeFactory.getInstance().decorateAnnotatedType(type, (KernelControllerContext)this.context);
    }

    public AnnotatedType<T> getType() {
        return this.type;
    }

    class AnnotationMetaDataVisitor
    extends AbstractMetaDataVisitor {
        public AnnotationMetaDataVisitor(KernelControllerContext context) {
            super(context.getBeanMetaData(), context);
        }

        public void before() {
            this.visitorNodeStack.push(this.bmd);
        }

        public void after() {
            this.visitorNodeStack.pop();
            this.visitorNodeStack = null;
        }
    }
}

