/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logbridge;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jboss.logbridge.BridgeHierarchy;
import org.jboss.logbridge.LevelMapper;

public class BridgeLogger
extends Logger {
    private java.util.logging.Logger jdkLogger;

    protected BridgeLogger(String s) {
        super(s);
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        this.syncLevels();
    }

    @Deprecated
    public void setPriority(Priority priority) {
        super.setPriority(priority);
        this.syncLevels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncLevels() {
        BridgeLogger bridgeLogger = this;
        synchronized (bridgeLogger) {
            BridgeHierarchy bridgeHierarchy;
            if (this.jdkLogger == null) {
                this.jdkLogger = java.util.logging.Logger.getLogger(this.name);
            }
            if ((bridgeHierarchy = (BridgeHierarchy)this.repository) == null) {
                return;
            }
            LevelMapper mapper = bridgeHierarchy.getLogBridgeHandler().getLevelMapper();
            Level ourLevel = this.getLevel();
            if (ourLevel == null) {
                this.jdkLogger.setLevel(null);
            } else {
                this.jdkLogger.setLevel(mapper.getSourceLevelForTargetLevel(ourLevel));
            }
        }
    }
}

