/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logbridge;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerRepository;
import org.jboss.logbridge.LevelMapper;

public final class LogBridgeHandler
extends Handler {
    private final LevelMapper levelMapper = new LevelMapper();
    private final Logger rootLogger = Logger.getLogger("");
    private final Map<org.apache.log4j.Logger, Logger> loggerMap = Collections.synchronizedMap(new WeakHashMap());
    private static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(LogBridgeHandler.class);

    public void setFilter(Filter newFilter) throws SecurityException {
    }

    public void setLevel(Level newLevel) throws SecurityException {
    }

    public boolean isLoggable(LogRecord record) {
        return true;
    }

    public void publish(LogRecord record) {
        org.apache.log4j.Logger targetLogger = org.apache.log4j.Logger.getLogger((String)record.getLoggerName());
        org.apache.log4j.Level targetLevel = this.levelMapper.getTargetLevelForSourceLevel(record.getLevel());
        String msg = record.getMessage();
        Object[] parameters = record.getParameters();
        String text = parameters != null ? MessageFormat.format(msg, parameters) : msg;
        targetLogger.log(record.getLoggerName(), (Priority)targetLevel, (Object)text, record.getThrown());
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }

    public void start() {
        this.rootLogger.addHandler(this);
        this.updateLoggers();
    }

    public void stop() {
        this.rootLogger.removeHandler(this);
    }

    LevelMapper getLevelMapper() {
        return this.levelMapper;
    }

    public void updateLoggers() {
        log.trace((Object)"Syncing up JDK logger levels from Log4j");
        Map<org.apache.log4j.Logger, Logger> loggerMap = this.loggerMap;
        LevelMapper levelMapper = this.levelMapper;
        loggerMap.clear();
        org.apache.log4j.Logger rootLogger = org.apache.log4j.Logger.getRootLogger();
        LoggerRepository repository = rootLogger.getLoggerRepository();
        Enumeration loggers = repository.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            org.apache.log4j.Logger logger = (org.apache.log4j.Logger)loggers.nextElement();
            String name = logger.getName();
            Logger jdkLogger = Logger.getLogger(name);
            org.apache.log4j.Level targetLevel = logger.getLevel();
            if (targetLevel == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Remapping logger \"" + name + "\" with null level"));
                }
                jdkLogger.setLevel(null);
                continue;
            }
            Level sourceLevel = levelMapper.getSourceLevelForTargetLevel(targetLevel);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Remapping logger \"" + name + "\" to JDK level \"" + sourceLevel + "\""));
            }
            loggerMap.put(logger, jdkLogger);
            jdkLogger.setLevel(sourceLevel);
        }
        Level sourceLevel = levelMapper.getSourceLevelForTargetLevel(rootLogger.getLevel());
        if (log.isTraceEnabled()) {
            log.trace((Object)("Remapping root logger to JDK level \"" + sourceLevel + "\""));
        }
        this.rootLogger.setLevel(sourceLevel);
    }
}

