/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator;

import org.jboss.logging.Annotations;

final class Message {
    private final int id;
    private final boolean hasId;
    private final String value;
    private final Annotations.FormatType format;

    public Message(int id, boolean hasId, String value, Annotations.FormatType format) {
        this.id = id;
        this.hasId = hasId;
        this.value = value;
        this.format = format;
    }

    public static Message of(int id, boolean hasId, String value, Annotations.FormatType format) {
        return new Message(id, hasId, value, format);
    }

    public int hashCode() {
        int prime = 31;
        int result = 0;
        result = 31 * result + this.id;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return this.format == other.format;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName()).append("(id=").append(this.id).append(",hasId=").append(this.hasId).append(",value=").append(this.value).append(",format=").append((Object)this.format).append(")");
        return stringBuilder.toString();
    }

    public int id() {
        return this.id;
    }

    public boolean hasId() {
        return this.hasId;
    }

    public String value() {
        return this.value;
    }

    public Annotations.FormatType format() {
        return this.format;
    }
}

