/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator;

import javax.lang.model.element.VariableElement;
import org.jboss.logging.Annotations;
import org.jboss.logging.util.ElementHelper;

public final class MethodParameter
implements Comparable<MethodParameter> {
    private final Annotations annotations;
    private final VariableElement param;
    private final String fullType;
    private final String formatterClass;

    MethodParameter(Annotations annotations, String fullType, VariableElement param) {
        this.annotations = annotations;
        this.fullType = fullType;
        this.param = param;
        this.formatterClass = null;
    }

    MethodParameter(Annotations annotations, String fullType, VariableElement param, String formatterClass) {
        this.annotations = annotations;
        this.param = param;
        this.fullType = fullType;
        this.formatterClass = formatterClass;
    }

    public boolean isCause() {
        return ElementHelper.isAnnotatedWith(this.param, this.annotations.cause());
    }

    public String fullType() {
        return this.fullType;
    }

    public String getFormatterClass() {
        return this.formatterClass;
    }

    public String name() {
        return this.param.getSimpleName().toString();
    }

    public int hashCode() {
        int prime = 31;
        int hash = 1;
        hash = 31 * hash + (this.fullType == null ? 0 : this.fullType.hashCode());
        hash = 31 * hash + (this.param == null ? 0 : this.param.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MethodParameter)) {
            return false;
        }
        MethodParameter other = (MethodParameter)obj;
        if (this.param == null ? other.param != null : !this.param.equals(other.param)) {
            return false;
        }
        return !(this.fullType == null ? other.fullType != null : !this.fullType.equals(other.fullType));
    }

    @Override
    public int compareTo(MethodParameter other) {
        int result = this.fullType.compareTo(other.fullType);
        result = result != 0 ? result : this.name().compareTo(other.name());
        return result;
    }
}

