/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.model;

import com.sun.codemodel.internal.JBlock;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JInvocation;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import java.lang.reflect.Method;
import org.jboss.logging.LoggingTools;
import org.jboss.logging.generator.MethodDescriptor;
import org.jboss.logging.generator.MethodParameter;
import org.jboss.logging.generator.ReturnType;
import org.jboss.logging.model.ImplementationClassModel;
import org.jboss.logging.model.ImplementationType;

public final class MessageLoggerImplementor
extends ImplementationClassModel {
    private static final String LOG_FIELD_NAME = "log";
    private final boolean extendsBasicLogger;
    private JFieldVar log;

    public MessageLoggerImplementor(String interfaceName, String projectCode, boolean extendsBasicLogger) {
        super(interfaceName, projectCode, ImplementationType.LOGGER);
        this.extendsBasicLogger = extendsBasicLogger;
    }

    @Override
    protected JCodeModel generateModel() throws IllegalStateException {
        JCodeModel codeModel = super.generateModel();
        this.log = this.getDefinedClass().field(10, LoggingTools.findLoggers().loggerClass(), LOG_FIELD_NAME);
        JFieldVar projectCodeVar = null;
        if (!this.getProjectCode().isEmpty()) {
            projectCodeVar = this.getDefinedClass().field(28, String.class, "projectCode");
            projectCodeVar.init(JExpr.lit((String)this.getProjectCode()));
        }
        JMethod constructor = this.getDefinedClass().constructor(1);
        JVar constructorParam = constructor.param(8, LoggingTools.findLoggers().loggerClass(), LOG_FIELD_NAME);
        JBlock body = constructor.body();
        body.directStatement("this." + this.log.name() + " = " + constructorParam.name() + ";");
        for (MethodDescriptor methodDesc : this.methodDescriptor) {
            JClass returnType = codeModel.ref(methodDesc.returnType().getReturnTypeAsString());
            String methodName = methodDesc.name();
            JMethod jMethod = this.getDefinedClass().method(9, (JType)returnType, methodName);
            jMethod.annotate(Override.class);
            JMethod msgMethod = this.addMessageMethod(methodName, methodDesc.messageValue());
            if (methodDesc.isLoggerMethod()) {
                this.createLoggerMethod(methodDesc, jMethod, msgMethod, (JVar)projectCodeVar);
                continue;
            }
            this.createBundleMethod(methodDesc, jMethod, msgMethod, (JVar)projectCodeVar);
        }
        if (this.extendsBasicLogger) {
            this.implementBasicLogger(codeModel);
        }
        return codeModel;
    }

    private void createLoggerMethod(MethodDescriptor methodDesc, JMethod method, JMethod msgMethod, JVar projectCodeVar) {
        JBlock body = method.body();
        StringBuilder logMethod = new StringBuilder(methodDesc.loggerMethod());
        JInvocation logInv = body.invoke((JExpression)this.log, logMethod.toString());
        if (methodDesc.hasCause()) {
            logInv.arg(JExpr.direct((String)methodDesc.cause().name()));
        }
        if (methodDesc.hasMessageId() && projectCodeVar != null) {
            String formatedId = String.format("%05d: ", methodDesc.messageId());
            logInv.arg(projectCodeVar.plus(JExpr.lit((String)formatedId)).plus((JExpression)JExpr.invoke((JMethod)msgMethod)));
        } else {
            logInv.arg((JExpression)JExpr.invoke((JMethod)msgMethod));
        }
        for (MethodParameter param : methodDesc.parameters()) {
            JClass paramType = this.getCodeModel().ref(param.fullType());
            JVar var = method.param(8, (JType)paramType, param.name());
            if (param.equals(methodDesc.cause())) continue;
            logInv.arg((JExpression)var);
        }
    }

    private void createBundleMethod(MethodDescriptor methodDesc, JMethod method, JMethod msgMethod, JVar projectCodeVar) {
        JBlock body = method.body();
        JClass returnField = this.getCodeModel().ref(method.type().fullName());
        JVar result = body.decl((JType)returnField, "result");
        if (methodDesc.parameters().isEmpty()) {
            if (methodDesc.returnType().isException()) {
                this.initCause(result, returnField, body, methodDesc, JExpr.invoke((JMethod)msgMethod));
            } else {
                result.init((JExpression)JExpr.invoke((JMethod)msgMethod));
            }
        } else {
            JClass formatter = this.getCodeModel().ref(methodDesc.messageFormat().formatClass());
            JInvocation formatterMethod = formatter.staticInvoke(methodDesc.messageFormat().staticMethod());
            if (methodDesc.hasMessageId() && projectCodeVar != null) {
                String formatedId = String.format("%05d: ", methodDesc.messageId());
                formatterMethod.arg(projectCodeVar.plus(JExpr.lit((String)formatedId)).plus((JExpression)JExpr.invoke((JMethod)msgMethod)));
            } else {
                formatterMethod.arg((JExpression)JExpr.invoke((JMethod)msgMethod));
            }
            for (MethodParameter param : methodDesc.parameters()) {
                JClass paramType = this.getCodeModel().ref(param.fullType());
                JVar paramVar = method.param(8, (JType)paramType, param.name());
                if (param.isCause()) continue;
                String formatterClass = param.getFormatterClass();
                if (formatterClass == null) {
                    formatterMethod.arg((JExpression)paramVar);
                    continue;
                }
                formatterMethod.arg((JExpression)JExpr._new((JType)JClass.parse((JCodeModel)this.getCodeModel(), (String)formatterClass)).arg((JExpression)paramVar));
            }
            if (methodDesc.returnType().isException()) {
                this.initCause(result, returnField, body, methodDesc, formatterMethod);
            } else {
                result.init((JExpression)formatterMethod);
            }
        }
        body._return((JExpression)result);
    }

    private void implementBasicLogger(JCodeModel codeModel) {
        for (Method m : LoggingTools.findLoggers().basicLoggerMethods()) {
            if (!m.getReturnType().isPrimitive()) {
                codeModel.ref(m.getReturnType());
            }
            JMethod blMethod = this.getDefinedClass().method(9, m.getReturnType(), m.getName());
            blMethod.annotate(Override.class);
            int paramSize = m.getParameterTypes().length;
            int argCount = 0;
            StringBuilder blBody = new StringBuilder();
            if (!m.getReturnType().equals(Void.TYPE)) {
                blBody.append("return ");
            }
            blBody.append("this.").append(this.log.name()).append(".").append(m.getName()).append("(");
            for (Class<?> param : m.getParameterTypes()) {
                codeModel.ref(param);
                blMethod.param(8, param, "arg" + argCount);
                blBody.append("arg").append(argCount);
                if (++argCount >= paramSize) continue;
                blBody.append(", ");
            }
            blBody.append(");");
            blMethod.body().directStatement(blBody.toString());
        }
    }

    private void initCause(JVar result, JClass returnField, JBlock body, MethodDescriptor methodDesc, JInvocation formatterMethod) {
        ReturnType desc = methodDesc.returnType();
        if (desc.hasStringAndThrowableConstructor() && methodDesc.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg((JExpression)formatterMethod).arg((JExpression)JExpr.ref((String)methodDesc.cause().name())));
        } else if (desc.hasThrowableAndStringConstructor() && methodDesc.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg((JExpression)JExpr.ref((String)methodDesc.cause().name())).arg((JExpression)formatterMethod));
        } else if (desc.hasStringConsturctor()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg((JExpression)formatterMethod));
            if (methodDesc.hasCause()) {
                JInvocation resultInv = body.invoke((JExpression)result, "initCause");
                resultInv.arg((JExpression)JExpr.ref((String)methodDesc.cause().name()));
            }
        } else if (desc.hasThrowableConstructor() && methodDesc.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg(methodDesc.cause().name()));
        } else if (methodDesc.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField));
            JInvocation resultInv = body.invoke((JExpression)result, "initCause");
            resultInv.arg((JExpression)JExpr.ref((String)methodDesc.cause().name()));
        } else {
            result.init((JExpression)JExpr._new((JClass)returnField));
        }
    }
}

