/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;
import org.jboss.logging.Annotations;
import org.jboss.logging.util.ElementHelper;
import org.jboss.logging.util.TransformationHelper;
import org.jboss.logging.validation.ElementValidator;
import org.jboss.logging.validation.ValidationErrorMessage;
import org.jboss.logging.validation.validator.BundleReturnTypeValidator;
import org.jboss.logging.validation.validator.LoggerReturnTypeValidator;
import org.jboss.logging.validation.validator.MessageAnnotationValidator;
import org.jboss.logging.validation.validator.MessageIdValidator;
import org.jboss.logging.validation.validator.MethodParameterValidator;

public class Validator {
    private final Annotations annotations;
    private final Types typeUtils;
    private final List<ElementValidator> validators;

    private Validator(Types typeUtils, Annotations annotations) {
        this.annotations = annotations;
        this.validators = new ArrayList<ElementValidator>();
        this.typeUtils = typeUtils;
    }

    public static Validator buildValidator(ProcessingEnvironment pev, Annotations annotations) {
        Validator validator = new Validator(pev.getTypeUtils(), annotations);
        validator.addElementValidator(new BundleReturnTypeValidator());
        validator.addElementValidator(new LoggerReturnTypeValidator());
        validator.addElementValidator(new MessageAnnotationValidator());
        validator.addElementValidator(new MethodParameterValidator());
        validator.addElementValidator(new MessageIdValidator());
        return validator;
    }

    public Collection<ValidationErrorMessage> validate(Collection<? extends TypeElement> typeElements) {
        ArrayList<ValidationErrorMessage> errorMessages = new ArrayList<ValidationErrorMessage>();
        for (TypeElement typeElement : typeElements) {
            try {
                Collection<ExecutableElement> elementMethods = ElementHelper.getInterfaceMethods(typeElement, this.typeUtils, null);
                for (ElementValidator validator : this.validators) {
                    errorMessages.addAll(validator.validate(typeElement, elementMethods, this.annotations));
                }
            }
            catch (Exception e) {
                errorMessages.add(new ValidationErrorMessage(typeElement, TransformationHelper.stackTraceToString(e)));
            }
        }
        return errorMessages;
    }

    public void addElementValidator(ElementValidator elementValidator) {
        this.validators.add(elementValidator);
    }
}

