/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.validation.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.jboss.logging.Annotations;
import org.jboss.logging.validation.ElementValidator;
import org.jboss.logging.validation.ValidationErrorMessage;

public class MessageIdValidator
implements ElementValidator {
    private static final String ERROR_MESSAGE = "Message id %s is not unique for method %s with project code %s.";
    private final Map<String, IdDescriptor> messageIdMap = new HashMap<String, IdDescriptor>();

    @Override
    public Collection<ValidationErrorMessage> validate(TypeElement element, Collection<ExecutableElement> elementMethods, Annotations annotations) {
        ArrayList<ValidationErrorMessage> errorMessages = new ArrayList<ValidationErrorMessage>();
        for (ExecutableElement method : elementMethods) {
            int messageId;
            if (!annotations.hasMessageId(method)) continue;
            String projectCode = annotations.projectCode(element);
            String key = this.createKey(projectCode, messageId = annotations.messageId(method));
            if (this.messageIdMap.containsKey(key)) {
                IdDescriptor idDesc = this.messageIdMap.get(key);
                if (!idDesc.error) {
                    errorMessages.add(ValidationErrorMessage.of(idDesc.method, ERROR_MESSAGE, messageId, idDesc.method, projectCode));
                    idDesc.error = true;
                }
                errorMessages.add(ValidationErrorMessage.of(method, ERROR_MESSAGE, messageId, method, projectCode));
                continue;
            }
            this.messageIdMap.put(key, new IdDescriptor(messageId, method));
        }
        return errorMessages;
    }

    private String createKey(String projectCode, int messageId) {
        StringBuilder result = new StringBuilder();
        result.append(projectCode);
        result.append(":");
        result.append(messageId);
        return result.toString();
    }

    private static class IdDescriptor {
        final int id;
        final ExecutableElement method;
        boolean error = false;

        public IdDescriptor(int id, ExecutableElement method) {
            this.id = id;
            this.method = method;
        }
    }
}

