/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.validation.validator;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.jboss.logging.Annotations;
import org.jboss.logging.validation.ElementValidator;
import org.jboss.logging.validation.ValidationErrorMessage;

public class MethodParameterValidator
implements ElementValidator {
    private static final String ERROR_MESSAGE = "The number of parameters, minus the cause parameter, must match all match all methods with the same name. Method %s accepts %d parameters and method %s accepts %d parameters.";

    @Override
    public Collection<ValidationErrorMessage> validate(TypeElement element, Collection<ExecutableElement> elementMethods, Annotations annotations) {
        ArrayList<ValidationErrorMessage> errorMessages = new ArrayList<ValidationErrorMessage>();
        HashSet<Name> methodNames = new HashSet<Name>();
        for (ExecutableElement method : elementMethods) {
            if (methodNames.add(method.getSimpleName())) {
                Collection<ExecutableElement> likeMethods = this.findByName(elementMethods, method.getSimpleName());
                int paramCount1 = method.getParameters().size() - (this.hasCause(method.getParameters(), annotations.cause()) ? 1 : 0);
                for (ExecutableElement executableElement : likeMethods) {
                    int paramCount2 = executableElement.getParameters().size() - (this.hasCause(executableElement.getParameters(), annotations.cause()) ? 1 : 0);
                    if (paramCount1 == paramCount2) continue;
                    errorMessages.add(ValidationErrorMessage.of(executableElement, ERROR_MESSAGE, method.toString(), method.getParameters().size(), executableElement.toString(), executableElement.getParameters().size()));
                }
            }
            boolean invalid = false;
            Annotation ogCause = null;
            for (VariableElement variableElement : method.getParameters()) {
                Annotation cause = variableElement.getAnnotation(annotations.cause());
                boolean bl = invalid = ogCause != null && cause != null;
                if (invalid) {
                    errorMessages.add(ValidationErrorMessage.of(variableElement, "Only one cause parameter allowed per method."));
                }
                ogCause = cause;
            }
        }
        return errorMessages;
    }

    private Collection<ExecutableElement> findByName(Collection<ExecutableElement> methods, Name methodName) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : methods) {
            if (!((Object)methodName).equals(method.getSimpleName())) continue;
            result.add(method);
        }
        return result;
    }

    private boolean hasCause(Collection<? extends VariableElement> params, Class<? extends Annotation> causeAnnotation) {
        for (VariableElement variableElement : params) {
            if (variableElement.getAnnotation(causeAnnotation) == null) continue;
            return true;
        }
        return false;
    }
}

