/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;
import org.jboss.logging.Annotations;
import org.jboss.logging.util.ElementHelper;
import org.jboss.logging.util.TransformationHelper;
import org.jboss.logging.validation.ElementValidator;
import org.jboss.logging.validation.ValidationErrorMessage;
import org.jboss.logging.validation.ValidationMessage;
import org.jboss.logging.validation.validator.BundleReturnTypeValidator;
import org.jboss.logging.validation.validator.LoggerReturnTypeValidator;
import org.jboss.logging.validation.validator.MessageAnnotationValidator;
import org.jboss.logging.validation.validator.MessageIdValidator;
import org.jboss.logging.validation.validator.MethodParameterValidator;

public final class Validator {
    private final Types typeUtils;
    private final List<ElementValidator> validators = new ArrayList<ElementValidator>();

    private Validator(Types typeUtils) {
        this.typeUtils = typeUtils;
    }

    public static Validator buildValidator(ProcessingEnvironment pev, Annotations annotations) {
        Validator validator = new Validator(pev.getTypeUtils());
        validator.addElementValidator(new BundleReturnTypeValidator(annotations, pev.getTypeUtils()));
        validator.addElementValidator(new LoggerReturnTypeValidator(annotations, pev.getTypeUtils()));
        validator.addElementValidator(new MessageAnnotationValidator(annotations, pev.getTypeUtils()));
        validator.addElementValidator(new MethodParameterValidator(annotations, pev.getTypeUtils()));
        validator.addElementValidator(new MessageIdValidator(annotations, pev.getTypeUtils()));
        return validator;
    }

    public Collection<ValidationMessage> validate(Collection<? extends TypeElement> typeElements) {
        ArrayList<ValidationMessage> errorMessages = new ArrayList<ValidationMessage>();
        for (TypeElement typeElement : typeElements) {
            try {
                Collection<ExecutableElement> elementMethods = ElementHelper.getInterfaceMethods(typeElement, this.typeUtils, null);
                for (ElementValidator validator : this.validators) {
                    errorMessages.addAll(validator.validate(typeElement, elementMethods));
                }
            }
            catch (Exception e) {
                errorMessages.add(new ValidationErrorMessage(typeElement, TransformationHelper.stackTraceToString(e)));
            }
        }
        return errorMessages;
    }

    public void addElementValidator(ElementValidator elementValidator) {
        this.validators.add(elementValidator);
    }
}

