/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.model;

import com.sun.codemodel.internal.JAssignmentTarget;
import com.sun.codemodel.internal.JBlock;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JInvocation;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JStatement;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.jboss.logging.generator.Tools;
import org.jboss.logging.generator.intf.model.MessageInterface;
import org.jboss.logging.generator.intf.model.Method;
import org.jboss.logging.generator.intf.model.Parameter;
import org.jboss.logging.generator.intf.model.ReturnType;
import org.jboss.logging.generator.model.ClassModelHelper;
import org.jboss.logging.generator.model.ImplementationClassModel;

final class MessageLoggerImplementor
extends ImplementationClassModel {
    private static final String LOG_FIELD_NAME = "log";
    private static final String FQCN_FIELD_NAME = "FQCN";
    private JFieldVar log;

    public MessageLoggerImplementor(MessageInterface messageInterface) {
        super(messageInterface);
    }

    @Override
    protected JCodeModel generateModel() throws IllegalStateException {
        JCodeModel codeModel = super.generateModel();
        this.log = this.getDefinedClass().field(10, Tools.loggers().loggerClass(), LOG_FIELD_NAME);
        JFieldVar projectCodeVar = null;
        if (!this.messageInterface().projectCode().isEmpty()) {
            projectCodeVar = this.getDefinedClass().field(28, String.class, "projectCode");
            projectCodeVar.init(JExpr.lit((String)this.messageInterface().projectCode()));
        }
        JFieldVar fqcn = this.getDefinedClass().field(28, String.class, FQCN_FIELD_NAME);
        fqcn.init((JExpression)this.getDefinedClass().dotclass().invoke("getName"));
        JMethod constructor = this.getDefinedClass().constructor(1);
        JVar constructorParam = constructor.param(8, Tools.loggers().loggerClass(), LOG_FIELD_NAME);
        JBlock constructorBody = constructor.body();
        constructorBody.assign((JAssignmentTarget)JExpr._this().ref((JVar)this.log), (JExpression)constructorParam);
        HashSet<Method> methods = new HashSet<Method>();
        methods.addAll(this.messageInterface().methods());
        for (MessageInterface messageInterface : this.messageInterface().extendedInterfaces()) {
            if (messageInterface.isBasicLogger()) {
                this.implementBasicLogger(codeModel, messageInterface);
                continue;
            }
            methods.addAll(messageInterface.methods());
        }
        for (Method method : methods) {
            JClass returnType = codeModel.ref(method.returnType().name());
            JMethod jMethod = this.getDefinedClass().method(9, (JType)returnType, method.name());
            jMethod.annotate(Override.class);
            JMethod msgMethod = this.addMessageMethod(method);
            if (method.isLoggerMethod()) {
                this.createLoggerMethod(method, jMethod, msgMethod, (JVar)projectCodeVar);
                continue;
            }
            this.createBundleMethod(method, jMethod, msgMethod, (JVar)projectCodeVar);
        }
        return codeModel;
    }

    private void createLoggerMethod(Method messageMethod, JMethod method, JMethod msgMethod, JVar projectCodeVar) {
        this.addThrownTypes(messageMethod, method);
        JBlock body = method.body();
        StringBuilder logMethod = new StringBuilder(messageMethod.loggerMethod());
        JInvocation logInv = body.invoke((JExpression)this.log, logMethod.toString());
        logInv.arg((JExpression)JExpr.ref((String)FQCN_FIELD_NAME));
        logInv.arg(JExpr.direct((String)messageMethod.logLevelParameter()));
        if (messageMethod.hasCause()) {
            logInv.arg(JExpr.direct((String)messageMethod.cause().name()));
        } else {
            logInv.arg(JExpr._null());
        }
        Method.Message message = messageMethod.message();
        if (message.hasId() && projectCodeVar != null) {
            String formattedId = ClassModelHelper.formatMessageId(message.id());
            logInv.arg(projectCodeVar.plus(JExpr.lit((String)formattedId)).plus((JExpression)JExpr.invoke((JMethod)msgMethod)));
        } else {
            logInv.arg((JExpression)JExpr.invoke((JMethod)msgMethod));
        }
        for (Parameter param : messageMethod.allParameters()) {
            JClass paramType = this.getCodeModel().ref(param.type());
            JVar var = method.param(8, (JType)paramType, param.name());
            String formatterClass = param.getFormatterClass();
            if (!param.isFormatParam()) continue;
            if (formatterClass == null) {
                logInv.arg((JExpression)var);
                continue;
            }
            logInv.arg((JExpression)JExpr._new((JClass)this.getCodeModel().ref(formatterClass)).arg((JExpression)var));
        }
    }

    private void implementBasicLogger(JCodeModel codeModel, MessageInterface messageInterface) {
        for (Method method : messageInterface.methods()) {
            Object returnType = method.returnType().equals(ReturnType.VOID) ? codeModel.VOID : (method.returnType().isPrimitive() ? JClass.parse((JCodeModel)codeModel, (String)method.returnType().name()) : codeModel.ref(method.returnType().name()));
            JMethod blMethod = this.getDefinedClass().method(9, (JType)returnType, method.name());
            blMethod.annotate(Override.class);
            JBlock body = blMethod.body();
            DelegateLogMethod delegateLogMethod = DelegateLogMethod.of(method);
            JInvocation logInv = JExpr.invoke((JExpression)this.log, (String)delegateLogMethod.methodName);
            LinkedHashMap<Parameter, JVar> args = new LinkedHashMap<Parameter, JVar>();
            HashMap<DelegateParameter, Object> delegateParameters = new HashMap<DelegateParameter, Object>();
            delegateParameters.put(DelegateParameter.FQCN, JExpr.ref((String)FQCN_FIELD_NAME));
            if (delegateLogMethod.level != null) {
                delegateParameters.put(DelegateParameter.LEVEL, JExpr.direct((String)delegateLogMethod.level));
            }
            boolean first = true;
            for (Parameter parameter : method.allParameters()) {
                JClass param = codeModel.ref(parameter.type());
                if (first) {
                    first = false;
                    if (!delegateLogMethod.isFormatMethod && parameter.isSameAs(String.class)) {
                        delegateParameters.put(DelegateParameter.FQCN, blMethod.param(8, (JType)param, parameter.name()));
                        continue;
                    }
                }
                if (parameter.isSameAs(Tools.loggers().logLevelClass())) {
                    delegateParameters.put(DelegateParameter.LEVEL, blMethod.param(8, (JType)param, parameter.name()));
                    continue;
                }
                if (parameter.isAssignableFrom(Throwable.class)) {
                    delegateParameters.put(DelegateParameter.THROWABLE, blMethod.param(8, (JType)param, parameter.name()));
                    continue;
                }
                if (parameter.isVarArgs()) {
                    args.put(parameter, blMethod.varParam((JType)param, parameter.name()));
                    continue;
                }
                if (parameter.isArray()) {
                    args.put(parameter, blMethod.param(8, (JType)param.array(), parameter.name()));
                    continue;
                }
                args.put(parameter, blMethod.param(8, (JType)param, parameter.name()));
            }
            if (ReturnType.VOID.equals(method.returnType())) {
                if (!delegateParameters.isEmpty()) {
                    logInv.arg((JExpression)delegateParameters.get((Object)DelegateParameter.FQCN));
                    if (delegateParameters.containsKey((Object)DelegateParameter.LEVEL)) {
                        logInv.arg((JExpression)delegateParameters.get((Object)DelegateParameter.LEVEL));
                    }
                    if (delegateParameters.containsKey((Object)DelegateParameter.THROWABLE)) {
                        logInv.arg((JExpression)delegateParameters.get((Object)DelegateParameter.THROWABLE));
                    } else {
                        logInv.arg(JExpr._null());
                    }
                    first = true;
                    for (Map.Entry entry : args.entrySet()) {
                        Parameter parameter = (Parameter)entry.getKey();
                        JExpression methodParameter = (JExpression)entry.getValue();
                        if (first && parameter.isSameAs(Object.class)) {
                            first = false;
                            StringBuilder sb = new StringBuilder();
                            sb.append(parameter.name()).append(" == null ? null : ").append(parameter.name()).append(".toString()");
                            logInv.arg(JExpr.direct((String)sb.toString()));
                            continue;
                        }
                        logInv.arg(methodParameter);
                    }
                }
                body.add((JStatement)logInv);
                continue;
            }
            if (delegateParameters.containsKey((Object)DelegateParameter.LEVEL)) {
                logInv.arg((JExpression)delegateParameters.get((Object)DelegateParameter.LEVEL));
            }
            body._return((JExpression)logInv);
        }
    }

    private static class DelegateLogMethod {
        final String level;
        final String methodName;
        final boolean isFormatMethod;

        private DelegateLogMethod(Method method) {
            String logMethod;
            String methodName = method.name();
            char lastChar = methodName.charAt(methodName.length() - 1);
            boolean bl = this.isFormatMethod = lastChar == 'f' || lastChar == 'v';
            if (methodName.startsWith(MessageLoggerImplementor.LOG_FIELD_NAME)) {
                logMethod = this.isFormatMethod ? methodName : methodName + "v";
                this.level = null;
            } else if (ReturnType.VOID.equals(method.returnType())) {
                if (this.isFormatMethod) {
                    logMethod = MessageLoggerImplementor.LOG_FIELD_NAME + lastChar;
                    this.level = "Logger.Level." + methodName.substring(0, methodName.length() - 1).toUpperCase(Locale.US);
                } else {
                    logMethod = "logv";
                    this.level = "Logger.Level." + methodName.substring(0, methodName.length()).toUpperCase(Locale.US);
                }
            } else {
                logMethod = methodName;
                this.level = null;
            }
            this.methodName = logMethod;
        }

        public static DelegateLogMethod of(Method method) {
            return new DelegateLogMethod(method);
        }
    }

    private static enum DelegateParameter {
        FQCN,
        LEVEL,
        THROWABLE;

    }
}

