/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.model;

import com.sun.codemodel.internal.CodeWriter;
import com.sun.codemodel.internal.JAnnotationUse;
import com.sun.codemodel.internal.JBlock;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JClassAlreadyExistsException;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JDocComment;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JTypeVar;
import java.io.IOException;
import javax.annotation.Generated;
import javax.tools.JavaFileObject;
import org.jboss.logging.generator.intf.model.MessageInterface;
import org.jboss.logging.generator.intf.model.MessageMethod;
import org.jboss.logging.generator.model.ClassModelHelper;
import org.jboss.logging.generator.model.JavaFileObjectCodeWriter;
import org.jboss.logging.generator.util.ElementHelper;

public abstract class ClassModel {
    private static final JType[] EMPTY_TYPE_ARRAY = new JTypeVar[0];
    private static final String INSTANCE_FIELD_NAME = "INSTANCE";
    private static final String GET_INSTANCE_METHOD_NAME = "readResolve";
    private final JCodeModel codeModel;
    private volatile JDefinedClass definedClass;
    private final MessageInterface messageInterface;
    private final String className;
    private final String superClassName;

    ClassModel(MessageInterface messageInterface, String className, String superClassName) {
        this.messageInterface = messageInterface;
        this.className = className;
        this.superClassName = superClassName;
        this.codeModel = new JCodeModel();
    }

    public final MessageInterface messageInterface() {
        return this.messageInterface;
    }

    public final void create(JavaFileObject fileObject) throws IOException, IllegalStateException {
        JCodeModel model = this.generateModel();
        model.build((CodeWriter)new JavaFileObjectCodeWriter(fileObject));
    }

    JCodeModel generateModel() throws IllegalStateException {
        JDefinedClass definedClass = this.getDefinedClass();
        JAnnotationUse generatedAnnotation = definedClass.annotate(Generated.class);
        generatedAnnotation.param("value", this.getClass().getName());
        generatedAnnotation.param("date", ClassModelHelper.generatedDateValue());
        JDocComment docComment = definedClass.javadoc();
        docComment.add((Object)"Warning this class consists of generated code.");
        if (this.superClassName != null) {
            definedClass._extends(this.codeModel.ref(this.superClassName));
        }
        definedClass._implements(this.codeModel.ref(ElementHelper.typeToString(this.messageInterface.name())));
        if (!this.messageInterface.extendedInterfaces().isEmpty()) {
            for (MessageInterface intf : this.messageInterface.extendedInterfaces()) {
                String interfaceName = ElementHelper.typeToString(intf.name());
                definedClass._implements(this.codeModel.ref(interfaceName));
            }
        }
        return this.codeModel;
    }

    JMethod addMessageMethod(MessageMethod messageMethod) {
        return this.addMessageMethod(messageMethod, messageMethod.message().value());
    }

    JMethod addMessageMethod(MessageMethod messageMethod, String messageValue) {
        JDefinedClass definedClass = this.getDefinedClass();
        if (messageValue == null) {
            return null;
        }
        String methodName = messageMethod.isOverloaded() ? messageMethod.name() + messageMethod.formatParameterCount() : messageMethod.name();
        JMethod method = definedClass.getMethod(messageMethod.messageMethodName(), EMPTY_TYPE_ARRAY);
        if (method == null) {
            JFieldVar methodField = (JFieldVar)definedClass.fields().get(methodName);
            if (methodField == null) {
                methodField = definedClass.field(28, String.class, methodName);
                methodField.init(JExpr.lit((String)messageValue));
            }
            JClass returnType = this.codeModel.ref(String.class);
            method = definedClass.method(2, (JType)returnType, messageMethod.messageMethodName());
            JBlock body = method.body();
            body._return((JExpression)methodField);
        }
        return method;
    }

    final JCodeModel getCodeModel() {
        return this.codeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final JDefinedClass getDefinedClass() {
        JDefinedClass result = this.definedClass;
        if (result == null) {
            JCodeModel jCodeModel = this.codeModel;
            synchronized (jCodeModel) {
                result = this.definedClass;
                if (result == null) {
                    try {
                        result = this.definedClass = this.codeModel._class(this.qualifiedClassName());
                    }
                    catch (JClassAlreadyExistsException e) {
                        throw new IllegalStateException("Class " + this.qualifiedClassName() + " has already been defined. Cannot generate the class.", e);
                    }
                }
            }
        }
        return result;
    }

    public final String qualifiedClassName() {
        return this.className;
    }

    protected JMethod createReadResolveMethod() {
        JDefinedClass definedClass = this.getDefinedClass();
        JFieldVar instance = definedClass.field(25, (JType)definedClass, INSTANCE_FIELD_NAME);
        instance.init((JExpression)JExpr._new((JClass)definedClass));
        JMethod readResolveMethod = definedClass.method(2, (JType)definedClass, GET_INSTANCE_METHOD_NAME);
        readResolveMethod.body()._return((JExpression)instance);
        return readResolveMethod;
    }
}

