/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.validation;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jboss.logging.generator.intf.model.MessageMethod;
import org.jboss.logging.generator.util.Comparison;
import org.jboss.logging.generator.util.Objects;
import org.jboss.logging.generator.validation.ValidationMessage;
import org.jboss.logging.generator.validation.ValidationMessageFactory;

public final class MessageIdValidator {
    public static final MessageIdValidator INSTANCE = new MessageIdValidator();
    private final Map<MessageKey, MessageMethod> usedMessageIds = new HashMap<MessageKey, MessageMethod>();

    private MessageIdValidator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ValidationMessage> validate(String projectCode, MessageMethod messageMethod) {
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        MessageMethod.Message message = messageMethod.message();
        if (message == null) {
            messages.add(ValidationMessageFactory.createError(messageMethod, "No message annotation found."));
        } else {
            MessageKey key = MessageIdValidator.createMessageKey(projectCode, message.id());
            if (!messageMethod.inheritsMessage()) {
                MessageIdValidator messageIdValidator = this;
                synchronized (messageIdValidator) {
                    if (this.usedMessageIds.containsKey(key)) {
                        MessageMethod previousMethod = this.usedMessageIds.get(key);
                        messages.add(ValidationMessageFactory.createError(previousMethod, "Message id %s is not unique for messageMethod %s with project code %s.", message.id(), previousMethod.name(), projectCode));
                        messages.add(ValidationMessageFactory.createError(messageMethod, "Message id %s is not unique for messageMethod %s with project code %s.", message.id(), messageMethod.name(), projectCode));
                    } else {
                        this.usedMessageIds.put(key, messageMethod);
                    }
                }
            }
        }
        return messages;
    }

    private static MessageKey createMessageKey(String projectCode, int messageId) {
        return new MessageKey(projectCode, messageId);
    }

    private static class MessageKey
    implements Comparable<MessageKey> {
        final String projectCode;
        final int id;

        MessageKey(String projectCode, int id) {
            this.projectCode = projectCode == null ? "" : projectCode;
            this.id = id;
        }

        public int hashCode() {
            return Objects.HashCodeBuilder.builder().add(this.projectCode).add(this.id).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MessageKey)) {
                return false;
            }
            MessageKey other = (MessageKey)obj;
            return Objects.areEqual(this.projectCode, other.projectCode) && Objects.areEqual(this.id, other.id);
        }

        @Override
        public int compareTo(MessageKey other) {
            return Comparison.begin().compare((Comparable<?>)((Object)this.projectCode), (Comparable<?>)((Object)other.projectCode)).compare(this.id, other.id).result();
        }
    }
}

