/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator;

import java.util.Arrays;
import java.util.ServiceLoader;
import org.jboss.logging.generator.Annotations;
import org.jboss.logging.generator.Loggers;
import org.jboss.logging.generator.apt.AptHelper;

public class Tools {
    private static volatile AptHelper aptHelper;
    private static volatile Annotations annotations;
    private static volatile Loggers loggers;
    private static final ServiceLoader<AptHelper> aptHelperLoader;
    private static final ServiceLoader<Annotations> annotationsLoader;
    private static final ServiceLoader<Loggers> loggersLoader;

    private Tools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Annotations annotations() {
        if (annotationsLoader == null) {
            throw Tools.servicesNotFound(Annotations.class);
        }
        Annotations result = annotations;
        if (result == null) {
            ServiceLoader<Annotations> serviceLoader = annotationsLoader;
            synchronized (serviceLoader) {
                result = annotations;
                if (result == null) {
                    if (annotationsLoader.iterator().hasNext()) {
                        annotations = result = annotationsLoader.iterator().next();
                    } else {
                        throw Tools.servicesNotFound(Annotations.class);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AptHelper aptHelper() {
        if (aptHelperLoader == null) {
            throw Tools.servicesNotFound(AptHelper.class);
        }
        AptHelper result = aptHelper;
        if (result == null) {
            ServiceLoader<AptHelper> serviceLoader = aptHelperLoader;
            synchronized (serviceLoader) {
                result = aptHelper;
                if (result == null) {
                    if (aptHelperLoader.iterator().hasNext()) {
                        aptHelper = result = aptHelperLoader.iterator().next();
                    } else {
                        throw Tools.servicesNotFound(AptHelper.class);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Loggers loggers() {
        if (loggersLoader == null) {
            throw Tools.servicesNotFound(Loggers.class);
        }
        Loggers result = loggers;
        if (result == null) {
            ServiceLoader<Loggers> serviceLoader = loggersLoader;
            synchronized (serviceLoader) {
                result = loggers;
                if (result == null) {
                    if (loggersLoader.iterator().hasNext()) {
                        loggers = result = loggersLoader.iterator().next();
                    } else {
                        throw Tools.servicesNotFound(Loggers.class);
                    }
                }
            }
        }
        return result;
    }

    private static IllegalStateException servicesNotFound(Class<?> clazz) {
        IllegalStateException result = new IllegalStateException(String.format("%1$s was not defined in META-INF/services/%1$s", clazz.getName()));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    static {
        aptHelperLoader = ServiceLoader.load(AptHelper.class, Tools.class.getClassLoader());
        annotationsLoader = ServiceLoader.load(Annotations.class, Tools.class.getClassLoader());
        loggersLoader = ServiceLoader.load(Loggers.class, Tools.class.getClassLoader());
    }
}

