/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.apt;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jboss.logging.generator.apt.ParameterFactory;
import org.jboss.logging.generator.intf.model.MessageMethod;
import org.jboss.logging.generator.intf.model.Parameter;
import org.jboss.logging.generator.intf.model.ThrowableType;
import org.jboss.logging.generator.util.ElementHelper;
import org.jboss.logging.generator.util.Objects;

final class ThrowableTypeFactory {
    private ThrowableTypeFactory() {
    }

    public static ThrowableType forReturnType(Elements elements, Types types, TypeMirror type, MessageMethod messageMethod) {
        AptReturnThrowableType result = new AptReturnThrowableType(elements, types, messageMethod, type);
        result.init();
        return result;
    }

    public static ThrowableType of(Elements elements, Types types, TypeMirror type) {
        AptThrowableType result = new AptThrowableType(elements, types, type);
        result.init();
        return result;
    }

    private static class AptReturnThrowableType
    extends AptThrowableType {
        private final Types types;
        private final MessageMethod messageMethod;
        private final Set<Parameter> constructionParameters;
        private boolean useConstructionParameters = false;

        private AptReturnThrowableType(Elements elements, Types types, MessageMethod messageMethod, TypeMirror type) {
            super(elements, types, type);
            this.types = types;
            this.messageMethod = messageMethod;
            this.constructionParameters = new LinkedHashSet<Parameter>();
        }

        @Override
        protected void init(List<? extends VariableElement> params) {
            if (!this.messageMethod.parameters(Parameter.ParameterType.CONSTRUCTION).isEmpty() && !this.useConstructionParameters) {
                Iterator<Parameter> methodParameterIterator = this.messageMethod.parameters(Parameter.ParameterType.CONSTRUCTION).iterator();
                LinkedHashSet<Parameter> matchedParams = new LinkedHashSet<Parameter>();
                boolean match = false;
                boolean causeFound = false;
                boolean messageFound = false;
                for (VariableElement variableElement : params) {
                    if (!causeFound && this.messageMethod.hasCause() && ElementHelper.isAssignableFrom(Throwable.class, variableElement.asType())) {
                        causeFound = true;
                        matchedParams.add(this.messageMethod.cause());
                        continue;
                    }
                    if (!messageFound && ElementHelper.isAssignableFrom(variableElement.asType(), String.class)) {
                        messageFound = true;
                        matchedParams.add(ParameterFactory.forMessageMethod(this.messageMethod));
                        continue;
                    }
                    if (methodParameterIterator.hasNext()) {
                        Parameter parameter = methodParameterIterator.next();
                        if (parameter.reference() instanceof VariableElement) {
                            VariableElement refType = (VariableElement)parameter.reference();
                            match = this.types.isAssignable(refType.asType(), variableElement.asType());
                        }
                        if (match) {
                            matchedParams.add(parameter);
                        }
                    }
                    if (match) continue;
                    break;
                }
                if (match) {
                    this.useConstructionParameters = true;
                    this.constructionParameters.addAll(matchedParams);
                }
            }
        }

        @Override
        public boolean useConstructionParameters() {
            return this.useConstructionParameters;
        }

        @Override
        public Set<Parameter> constructionParameters() {
            return this.constructionParameters;
        }
    }

    private static class AptThrowableType
    implements ThrowableType {
        private final Elements elements;
        private final Types types;
        private final TypeMirror type;
        private boolean defaultConstructor = false;
        private boolean stringConstructor = false;
        private boolean throwableConstructor = false;
        private boolean stringAndThrowableConstructor = false;
        private boolean throwableAndStringConstructor = false;

        private AptThrowableType(Elements elements, Types types, TypeMirror type) {
            this.elements = elements;
            this.types = types;
            this.type = type;
        }

        protected final void init() {
            if (!this.type.getKind().isPrimitive() && this.type.getKind() != TypeKind.VOID) {
                Element element = this.types.asElement(this.type);
                List<ExecutableElement> constructors = ElementFilter.constructorsIn(element.getEnclosedElements());
                for (ExecutableElement constructor : constructors) {
                    if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                    List<? extends VariableElement> params = constructor.getParameters();
                    switch (params.size()) {
                        case 0: {
                            this.defaultConstructor = true;
                            break;
                        }
                        case 1: {
                            if (ElementHelper.isAssignableFrom(params.get(0).asType(), String.class)) {
                                this.stringConstructor = true;
                                break;
                            }
                            if (!ElementHelper.isAssignableFrom(Throwable.class, params.get(0).asType())) break;
                            this.throwableConstructor = true;
                            break;
                        }
                        case 2: {
                            if (ElementHelper.isAssignableFrom(params.get(0).asType(), String.class) && ElementHelper.isAssignableFrom(Throwable.class, params.get(1).asType())) {
                                this.stringAndThrowableConstructor = true;
                                break;
                            }
                            if (!ElementHelper.isAssignableFrom(Throwable.class, params.get(0).asType()) || !ElementHelper.isAssignableFrom(params.get(1).asType(), String.class)) break;
                            this.throwableAndStringConstructor = true;
                        }
                    }
                    this.init(params);
                }
            }
        }

        protected void init(List<? extends VariableElement> params) {
        }

        @Override
        public boolean hasDefaultConstructor() {
            return this.defaultConstructor;
        }

        @Override
        public boolean hasStringAndThrowableConstructor() {
            return this.stringAndThrowableConstructor;
        }

        @Override
        public boolean hasStringConstructor() {
            return this.stringConstructor;
        }

        @Override
        public boolean hasThrowableAndStringConstructor() {
            return this.throwableAndStringConstructor;
        }

        @Override
        public boolean hasThrowableConstructor() {
            return this.throwableConstructor;
        }

        @Override
        public boolean useConstructionParameters() {
            return false;
        }

        @Override
        public Set<Parameter> constructionParameters() {
            return Collections.emptySet();
        }

        @Override
        public boolean isChecked() {
            return !ElementHelper.isAssignableFrom(this.type, RuntimeException.class) && !ElementHelper.isAssignableFrom(this.type, Error.class);
        }

        @Override
        public String name() {
            return ((Object)this.type).toString();
        }

        public int hashCode() {
            return Objects.HashCodeBuilder.builder().add(this.type).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AptThrowableType)) {
                return false;
            }
            AptThrowableType other = (AptThrowableType)obj;
            return Objects.areEqual(this.type, other.type);
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add("type", this.type).add("stringConstructor", this.stringConstructor).add("throwableConstructor", this.throwableConstructor).add("stringAndThrowableConstructor", this.stringAndThrowableConstructor).add("throwableAndStringConstructor", this.throwableAndStringConstructor).toString();
        }

        @Override
        public TypeMirror reference() {
            return this.type;
        }

        @Override
        public String type() {
            return this.name();
        }

        @Override
        public boolean isAssignableFrom(Class<?> type) {
            TypeMirror typeMirror = this.elements.getTypeElement(type.getName()).asType();
            return this.types.isAssignable(typeMirror, this.type);
        }

        @Override
        public boolean isSubtypeOf(Class<?> type) {
            TypeMirror typeMirror = this.elements.getTypeElement(type.getName()).asType();
            return this.types.isSubtype(this.type, typeMirror);
        }

        @Override
        public boolean isSameAs(Class<?> type) {
            return this.name().equals(type.getName());
        }

        @Override
        public int compareTo(ThrowableType o) {
            return this.name().compareTo(o.name());
        }
    }
}

