/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.apt;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.jboss.logging.generator.apt.AbstractGenerator;
import org.jboss.logging.generator.intf.model.MessageInterface;
import org.jboss.logging.generator.intf.model.MessageMethod;
import org.jboss.logging.generator.util.ElementHelper;
import org.jboss.logging.generator.util.Strings;

@SupportedOptions(value={"generatedTranslationFilesPath"})
final class TranslationFileGenerator
extends AbstractGenerator {
    public static final String GENERATED_FILES_PATH_OPTION = "generatedTranslationFilesPath";
    public static final String GENERATED_FILE_EXTENSION = ".i18n_locale_COUNTRY_VARIANT.properties";
    public static final String DEFAULT_FILE_EXTENSION = ".i18n.properties";
    private static final String DEFAULT_FILE_COMMENT = "# This file is for reference only, changes have no effect on the generated interface implementations.";
    private final String generatedFilesPath;

    public TranslationFileGenerator(ProcessingEnvironment processingEnv) {
        super(processingEnv);
        Map<String, String> options = processingEnv.getOptions();
        this.generatedFilesPath = options.get(GENERATED_FILES_PATH_OPTION);
    }

    @Override
    public void processTypeElement(TypeElement annotation, TypeElement element, MessageInterface messageInterface) {
        if (this.generatedFilesPath != null && element.getKind().isInterface()) {
            String packageName = this.elementUtils().getPackageOf(element).getQualifiedName().toString();
            String relativePath = packageName.replace('.', File.separatorChar);
            String fileName = ElementHelper.getPrimaryClassNamePrefix(element) + GENERATED_FILE_EXTENSION;
            this.generateSkeletalTranslationFile(relativePath, fileName, messageInterface);
        }
        this.generateDefaultTranslationFile(messageInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void generateSkeletalTranslationFile(String relativePath, String fileName, MessageInterface messageInterface) {
        block15: {
            if (messageInterface == null) {
                throw new NullPointerException("The translations parameter cannot be null");
            }
            File pathFile = new File(this.generatedFilesPath, relativePath);
            pathFile.mkdirs();
            File file = new File(pathFile, fileName);
            BufferedWriter writer = null;
            writer = new BufferedWriter(new FileWriter(file));
            HashSet<String> processed = new HashSet<String>();
            for (MessageMethod messageMethod : messageInterface.methods()) {
                if (!processed.add(messageMethod.translationKey())) continue;
                writer.write(String.format("# %s", messageMethod.message().value()));
                writer.newLine();
                writer.write(String.format("%s=", messageMethod.translationKey()));
                writer.newLine();
            }
            try {
                if (writer != null) {
                    writer.close();
                }
                break block15;
            }
            catch (IOException e) {
                this.logger().error((Throwable)e, "Cannot close generated skeletal translation file %s", fileName);
            }
            break block15;
            catch (IOException e) {
                try {
                    this.logger().error((Throwable)e, "Cannot write generated skeletal translation file %s", fileName);
                }
                catch (Throwable throwable) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException e2) {
                        this.logger().error((Throwable)e2, "Cannot close generated skeletal translation file %s", fileName);
                    }
                    throw throwable;
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e3) {
                    this.logger().error((Throwable)e3, "Cannot close generated skeletal translation file %s", fileName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void generateDefaultTranslationFile(MessageInterface messageInterface) {
        block14: {
            String fileName = messageInterface.simpleName() + DEFAULT_FILE_EXTENSION;
            BufferedWriter writer = null;
            FileObject fileObject = this.filer().createResource(StandardLocation.CLASS_OUTPUT, messageInterface.packageName(), fileName, new Element[0]);
            writer = new BufferedWriter(new OutputStreamWriter(fileObject.openOutputStream()));
            writer.write(Strings.fill("#", DEFAULT_FILE_COMMENT.length()));
            writer.newLine();
            writer.write("#");
            writer.newLine();
            writer.write(DEFAULT_FILE_COMMENT);
            writer.newLine();
            writer.write("#");
            writer.newLine();
            writer.write(Strings.fill("#", DEFAULT_FILE_COMMENT.length()));
            writer.newLine();
            writer.newLine();
            HashSet<String> processed = new HashSet<String>();
            for (MessageMethod messageMethod : messageInterface.methods()) {
                if (!processed.add(messageMethod.translationKey())) continue;
                MessageMethod.Message msg = messageMethod.message();
                writer.write(String.format("# Id: %s", msg.hasId() ? Integer.valueOf(msg.id()) : "none"));
                writer.newLine();
                writer.write(String.format("# Message: %s", msg.value()));
                writer.newLine();
                writer.write(String.format("%s=", messageMethod.translationKey()));
                writer.write(messageMethod.message().value());
                writer.newLine();
            }
            try {
                if (writer != null) {
                    writer.close();
                }
                break block14;
            }
            catch (IOException e) {
                this.logger().error((Throwable)e, "Cannot write generated default translation file %s", fileName);
            }
            break block14;
            catch (IOException e) {
                try {
                    this.logger().error((Throwable)e, "Cannot write generated default translation file %s", fileName);
                }
                catch (Throwable throwable) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException e2) {
                        this.logger().error((Throwable)e2, "Cannot write generated default translation file %s", fileName);
                    }
                    throw throwable;
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e3) {
                    this.logger().error((Throwable)e3, "Cannot write generated default translation file %s", fileName);
                }
            }
        }
    }
}

