/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jboss.logging.generator.intf.model.MessageInterface;

public final class ClassModelHelper {
    private static final String STRING_ID_FORMAT = "%06d: ";

    private ClassModelHelper() {
    }

    static String generatedDateValue() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        return sdf.format(new Date());
    }

    public static String formatMessageId(int messageId) {
        return String.format(STRING_ID_FORMAT, messageId);
    }

    public static String implementationClassName(MessageInterface messageInterface) throws IllegalArgumentException {
        StringBuilder result = new StringBuilder(messageInterface.name());
        if (messageInterface.isMessageBundle()) {
            result.append("_$bundle");
        } else if (messageInterface.isMessageLogger()) {
            result.append("_$logger");
        } else {
            throw new IllegalArgumentException(String.format("Message interface %s is not a message bundle or message logger.", messageInterface));
        }
        return result.toString();
    }

    public static String implementationClassName(MessageInterface messageInterface, String translationSuffix) throws IllegalArgumentException {
        return ClassModelHelper.implementationClassName(messageInterface) + translationSuffix;
    }
}

