/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.logging;

/**
 * LoggerPlugin implementation producing no output at all. Used for client
 * side logging when no log4j.jar is available on the classpath.
 *
 * @see org.jboss.logging.Logger
 * @see LoggerPluginInstance
 *
 * @author  <a href="mailto:sacha.labourey@cogito-info.ch">Sacha Labourey</a>.
 * @author David M. Lloyd
 * @version $Revision: 3403 $
 */
public class NullLoggerPluginInstance extends AbstractLoggerPluginInstance
{
    /**
     * Construct a new instance.
     *
     * @param name the logger name to use
     * @param loggerPlugin
     */
    public NullLoggerPluginInstance(final String name, final LoggerPlugin loggerPlugin) {
        super(name, null, loggerPlugin);
    }

    /** {@inheritDoc} */
    public boolean isEnabled(final Logger.Level level) {
        return false;
    }

    /** {@inheritDoc} */
    public void logf(final Logger.Level level, final String loggerFqcn, final String format, final Object[] params, final Throwable t) {
    }

    /** {@inheritDoc} */
    public void log(final Logger.Level level, final String loggerFqcn, final Object message, final Object[] params, final Throwable t) {
    }
}
