/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.jboss.logging.LoggerPlugin;
import org.jboss.logging.LoggerPluginInstance;
import org.jboss.logging.NullLoggerPlugin;
import org.jboss.logging.NullLoggerPluginInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logger
implements Serializable {
    private static volatile LoggerPlugin plugin;
    private static final long serialVersionUID = 4232175575988879434L;
    private static final String FQCN;
    protected static String PLUGIN_CLASS_PROP;
    protected static final String LOG4J_PLUGIN_CLASS_NAME = "org.jboss.logging.log4j.Log4jLoggerPlugin";
    protected static Class<?> pluginClass;
    protected static String pluginClassName;
    private final String name;
    private final String resourceBundleName;
    protected transient LoggerPluginInstance loggerDelegate = null;

    public static String getPluginClassName() {
        return pluginClassName;
    }

    public static void setPluginClassName(String pluginClassName) {
        if (!pluginClassName.equals(Logger.pluginClassName)) {
            Logger.pluginClassName = pluginClassName;
            Logger.init();
        }
    }

    Logger(String name, String resourceBundleName, LoggerPluginInstance loggerDelegate) {
        this.name = name;
        this.resourceBundleName = resourceBundleName;
        this.loggerDelegate = loggerDelegate;
    }

    public String getName() {
        return this.name;
    }

    public LoggerPluginInstance getLoggerPluginInstance() {
        return this.loggerDelegate;
    }

    public boolean isTraceEnabled() {
        return this.loggerDelegate.isEnabled(Level.TRACE);
    }

    public void trace(Object message) {
        this.loggerDelegate.log(Level.TRACE, FQCN, message, null, null);
    }

    public void trace(Object message, Throwable t) {
        this.loggerDelegate.log(Level.TRACE, FQCN, message, null, t);
    }

    public void trace(String loggerFqcn, Object message, Throwable t) {
        this.loggerDelegate.log(Level.TRACE, loggerFqcn, message, null, t);
    }

    public void trace(Object message, Object[] params) {
        this.loggerDelegate.log(Level.TRACE, FQCN, message, params, null);
    }

    public void trace(Object message, Object[] params, Throwable t) {
        this.loggerDelegate.log(Level.TRACE, FQCN, message, params, t);
    }

    public void trace(String loggerFqcn, Object message, Object[] params, Throwable t) {
        this.loggerDelegate.log(Level.TRACE, loggerFqcn, message, params, t);
    }

    public void tracef(String format, Object ... params) {
        this.loggerDelegate.logf(Level.TRACE, FQCN, format, params, null);
    }

    public void tracef(Throwable t, String format, Object ... params) {
        this.loggerDelegate.logf(Level.TRACE, FQCN, format, params, t);
    }

    public boolean isDebugEnabled() {
        return this.loggerDelegate.isEnabled(Level.DEBUG);
    }

    public void debug(Object message) {
        this.loggerDelegate.log(Level.DEBUG, FQCN, message, null, null);
    }

    public void debug(Object message, Throwable t) {
        this.loggerDelegate.log(Level.DEBUG, FQCN, message, null, t);
    }

    public void debug(String loggerFqcn, Object message, Throwable t) {
        this.loggerDelegate.log(Level.DEBUG, loggerFqcn, message, null, t);
    }

    public void debug(Object message, Object[] params) {
        this.loggerDelegate.log(Level.DEBUG, FQCN, message, params, null);
    }

    public void debug(Object message, Object[] params, Throwable t) {
        this.loggerDelegate.log(Level.DEBUG, FQCN, message, params, t);
    }

    public void debug(String loggerFqcn, Object message, Object[] params, Throwable t) {
        this.loggerDelegate.log(Level.DEBUG, loggerFqcn, message, params, t);
    }

    public void debugf(String format, Object ... params) {
        this.loggerDelegate.logf(Level.DEBUG, FQCN, format, params, null);
    }

    public void debugf(Throwable t, String format, Object ... params) {
        this.loggerDelegate.logf(Level.DEBUG, FQCN, format, params, t);
    }

    public boolean isInfoEnabled() {
        return this.loggerDelegate.isEnabled(Level.INFO);
    }

    public void info(Object message) {
        this.loggerDelegate.log(Level.INFO, FQCN, message, null, null);
    }

    public void info(Object message, Throwable t) {
        this.loggerDelegate.log(Level.INFO, FQCN, message, null, t);
    }

    public void info(String loggerFqcn, Object message, Throwable t) {
        this.loggerDelegate.log(Level.INFO, loggerFqcn, message, null, t);
    }

    public void info(Object message, Object[] params) {
        this.loggerDelegate.log(Level.INFO, FQCN, message, params, null);
    }

    public void info(Object message, Object[] params, Throwable t) {
        this.loggerDelegate.log(Level.INFO, FQCN, message, params, t);
    }

    public void info(String loggerFqcn, Object message, Object[] params, Throwable t) {
        this.loggerDelegate.log(Level.INFO, loggerFqcn, message, params, t);
    }

    public void infof(String format, Object ... params) {
        this.loggerDelegate.logf(Level.INFO, FQCN, format, params, null);
    }

    public void infof(Throwable t, String format, Object ... params) {
        this.loggerDelegate.logf(Level.INFO, FQCN, format, params, t);
    }

    public void warn(Object message) {
        this.loggerDelegate.log(Level.WARN, FQCN, message, null, null);
    }

    public void warn(Object message, Throwable t) {
        this.loggerDelegate.log(Level.WARN, FQCN, message, null, t);
    }

    public void warn(String loggerFqcn, Object message, Throwable t) {
        this.loggerDelegate.log(Level.WARN, loggerFqcn, message, null, t);
    }

    public void warn(Object message, Object[] params) {
        this.loggerDelegate.log(Level.WARN, FQCN, message, params, null);
    }

    public void warn(Object message, Object[] params, Throwable t) {
        this.loggerDelegate.log(Level.WARN, FQCN, message, params, t);
    }

    public void warn(String loggerFqcn, Object message, Object[] params, Throwable t) {
        this.loggerDelegate.log(Level.WARN, loggerFqcn, message, params, t);
    }

    public void warnf(String format, Object ... params) {
        this.loggerDelegate.logf(Level.WARN, FQCN, format, params, null);
    }

    public void warnf(Throwable t, String format, Object ... params) {
        this.loggerDelegate.logf(Level.WARN, FQCN, format, params, t);
    }

    public void error(Object message) {
        this.loggerDelegate.log(Level.ERROR, FQCN, message, null, null);
    }

    public void error(Object message, Throwable t) {
        this.loggerDelegate.log(Level.ERROR, FQCN, message, null, t);
    }

    public void error(String loggerFqcn, Object message, Throwable t) {
        this.loggerDelegate.log(Level.ERROR, loggerFqcn, message, null, t);
    }

    public void error(Object message, Object[] params) {
        this.loggerDelegate.log(Level.ERROR, FQCN, message, params, null);
    }

    public void error(Object message, Object[] params, Throwable t) {
        this.loggerDelegate.log(Level.ERROR, FQCN, message, params, t);
    }

    public void error(String loggerFqcn, Object message, Object[] params, Throwable t) {
        this.loggerDelegate.log(Level.ERROR, loggerFqcn, message, params, t);
    }

    public void errorf(String format, Object ... params) {
        this.loggerDelegate.logf(Level.ERROR, FQCN, format, params, null);
    }

    public void errorf(Throwable t, String format, Object ... params) {
        this.loggerDelegate.logf(Level.ERROR, FQCN, format, params, t);
    }

    public void fatal(Object message) {
        this.loggerDelegate.log(Level.FATAL, FQCN, message, null, null);
    }

    public void fatal(Object message, Throwable t) {
        this.loggerDelegate.log(Level.FATAL, FQCN, message, null, t);
    }

    public void fatal(String loggerFqcn, Object message, Throwable t) {
        this.loggerDelegate.log(Level.FATAL, loggerFqcn, message, null, t);
    }

    public void fatal(Object message, Object[] params) {
        this.loggerDelegate.log(Level.FATAL, FQCN, message, params, null);
    }

    public void fatal(Object message, Object[] params, Throwable t) {
        this.loggerDelegate.log(Level.FATAL, FQCN, message, params, t);
    }

    public void fatal(String loggerFqcn, Object message, Object[] params, Throwable t) {
        this.loggerDelegate.log(Level.FATAL, loggerFqcn, message, params, t);
    }

    public void fatalf(String format, Object ... params) {
        this.loggerDelegate.logf(Level.FATAL, FQCN, format, params, null);
    }

    public void fatalf(Throwable t, String format, Object ... params) {
        this.loggerDelegate.logf(Level.FATAL, FQCN, format, params, t);
    }

    public void log(Level level, Object message) {
        this.loggerDelegate.log(level, FQCN, message, null, null);
    }

    public void log(Level level, Object message, Object[] params) {
        this.loggerDelegate.log(level, FQCN, message, params, null);
    }

    public void log(Level level, Object message, Object[] params, Throwable t) {
        this.loggerDelegate.log(level, FQCN, message, params, t);
    }

    public void log(String loggerFqcn, Level level, Object message, Object[] params, Throwable t) {
        this.loggerDelegate.log(level, loggerFqcn, message, params, t);
    }

    public void logf(Level level, String format, Object ... params) {
        this.loggerDelegate.logf(level, FQCN, format, params, null);
    }

    public void logf(Level level, Throwable t, String format, Object ... params) {
        this.loggerDelegate.logf(level, FQCN, format, params, t);
    }

    public void logf(String loggerFqcn, Level level, Throwable t, String format, Object ... params) {
        this.loggerDelegate.logf(level, loggerFqcn, format, params, t);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (pluginClass == null) {
            Logger.init();
        }
    }

    private Object readResolve() {
        return Logger.getDelegatePluginInstance(this.name, this.resourceBundleName).getLogger();
    }

    public static Logger getI18nLogger(String name, String resourceBundleName) {
        return Logger.getDelegatePluginInstance(name, resourceBundleName).getLogger();
    }

    public static Logger getI18nLogger(Class<?> clazz, String resourceBundleName) {
        return Logger.getI18nLogger(clazz.getName(), resourceBundleName);
    }

    public static Logger getLogger(String name) {
        return Logger.getI18nLogger(name, null);
    }

    public static Logger getLogger(String name, String suffix) {
        return Logger.getLogger(name == null || name.length() == 0 ? suffix : name + "." + suffix);
    }

    public static Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getLogger(Class<?> clazz, String suffix) {
        return Logger.getLogger(clazz.getName(), suffix);
    }

    public LoggerPlugin getLoggerPlugin() {
        return this.getLoggerPluginInstance().getLoggerPlugin();
    }

    static LoggerPluginInstance getDelegatePluginInstance(String name, String resourceBundleName) {
        LoggerPluginInstance instance;
        LoggerPlugin plugin;
        try {
            plugin = (LoggerPlugin)pluginClass.newInstance();
        }
        catch (Throwable e) {
            plugin = new NullLoggerPlugin();
        }
        try {
            instance = plugin.getInstance(name, resourceBundleName);
        }
        catch (Throwable e) {
            System.err.println("Failed to initalize plugin: " + plugin + ", cause: " + e.toString());
            instance = new NullLoggerPluginInstance(name, NullLoggerPlugin.INSTANCE);
        }
        return instance;
    }

    protected static void init() {
        try {
            if (pluginClassName == null) {
                pluginClassName = System.getProperty(PLUGIN_CLASS_PROP, LOG4J_PLUGIN_CLASS_NAME);
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            pluginClass = cl.loadClass(pluginClassName);
        }
        catch (Throwable e) {
            pluginClass = NullLoggerPluginInstance.class;
        }
    }

    static {
        FQCN = Logger.class.getName();
        PLUGIN_CLASS_PROP = "org.jboss.logging.Logger.pluginClass";
        pluginClass = null;
        pluginClassName = null;
        Logger.init();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

