/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jboss.logging.Cause;
import org.jboss.logging.FormatWith;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Message;
import org.jboss.logging.generator.ReturnType;
import org.jboss.logging.util.ElementHelper;

public class MethodDescriptor
implements Iterable<MethodDescriptor>,
Comparable<MethodDescriptor> {
    private static List<MethodDescriptor> descriptors;
    private MethodParameter cause;
    private ReturnType returnType;
    private LogMessage logMessage;
    private Message message;
    private ExecutableElement method;
    private final List<MethodParameter> parameters = new ArrayList<MethodParameter>();

    private MethodDescriptor() {
    }

    protected static MethodDescriptor create(Elements elementUtil, Types typeUtil, Collection<ExecutableElement> methods) {
        MethodDescriptor result = new MethodDescriptor();
        descriptors = new ArrayList<MethodDescriptor>();
        boolean first = true;
        for (ExecutableElement method : methods) {
            MethodDescriptor current = null;
            if (first) {
                current = result;
                first = false;
            } else {
                current = new MethodDescriptor();
            }
            current.init(elementUtil, typeUtil, method);
            descriptors.add(current);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MethodDescriptor)) {
            return false;
        }
        MethodDescriptor other = (MethodDescriptor)obj;
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append("(name=");
        stringBuilder.append(this.name());
        stringBuilder.append(",message=");
        stringBuilder.append(this.message());
        stringBuilder.append(",logMessae=");
        stringBuilder.append(this.logMessage());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(MethodDescriptor o) {
        int c = this.method.getSimpleName().toString().compareTo(o.method.getSimpleName().toString());
        c = c != 0 ? c : this.method.getKind().compareTo(o.method.getKind());
        int n = c = c != 0 ? c : this.method.getParameters().size() - o.method.getParameters().size();
        if (c == 0) {
            List<? extends VariableElement> parms = this.method.getParameters();
            for (int i = 0; i < parms.size(); ++i) {
                VariableElement var1 = parms.get(i);
                VariableElement var2 = o.method.getParameters().get(i);
                c = var1.getKind().compareTo(var2.getKind());
            }
        }
        return c;
    }

    @Override
    public Iterator<MethodDescriptor> iterator() {
        Collection<Object> result = null;
        result = descriptors == null ? Collections.emptyList() : Collections.unmodifiableCollection(descriptors);
        return result.iterator();
    }

    public Message message() {
        return this.message;
    }

    public String name() {
        return this.method.getSimpleName().toString();
    }

    public boolean hasCause() {
        return this.cause != null;
    }

    public MethodParameter cause() {
        return this.cause;
    }

    public ReturnType returnType() {
        return this.returnType;
    }

    public LogMessage logMessage() {
        return this.logMessage;
    }

    public Collection<MethodParameter> parameters() {
        return Collections.unmodifiableCollection(this.parameters);
    }

    public boolean isLoggerMethod() {
        return ElementHelper.isLoggerMethod(this.method);
    }

    public Collection<MethodDescriptor> find(String methodName) {
        LinkedHashSet<MethodDescriptor> result = new LinkedHashSet<MethodDescriptor>();
        for (MethodDescriptor methodDesc : descriptors) {
            if (!methodName.equals(methodDesc.name())) continue;
            result.add(methodDesc);
        }
        return result;
    }

    private void init(Elements elementUtil, Types typeUtil, ExecutableElement method) {
        this.method = method;
        Message message = method.getAnnotation(Message.class);
        LogMessage logMessage = method.getAnnotation(LogMessage.class);
        this.returnType = ReturnType.of(method.getReturnType(), typeUtil);
        Collection<MethodDescriptor> methodDescriptors = this.find(this.name());
        for (MethodDescriptor methodDescriptor : methodDescriptors) {
            if (methodDescriptor.message() != null && message == null) {
                message = methodDescriptor.message();
            }
            if (message == null) continue;
            break;
        }
        for (MethodDescriptor methodDescriptor : methodDescriptors) {
            if (methodDescriptor.message != null) continue;
            methodDescriptor.message = message;
            descriptors.remove(methodDescriptor);
            descriptors.add(methodDescriptor);
        }
        for (VariableElement variableElement : method.getParameters()) {
            if (variableElement.getAnnotation(Cause.class) != null) {
                this.cause = new MethodParameter(typeUtil.asElement(variableElement.asType()).toString(), variableElement);
            }
            String formatClass = null;
            for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                if (!annotationType.equals(typeUtil.getDeclaredType(elementUtil.getTypeElement(FormatWith.class.getName()), new TypeMirror[0]))) continue;
                AnnotationValue value = annotationMirror.getElementValues().values().iterator().next();
                formatClass = ((TypeElement)((DeclaredType)value.getValue()).asElement()).getQualifiedName().toString();
            }
            if (variableElement.asType().getKind().isPrimitive()) {
                this.parameters.add(new MethodParameter(((Object)variableElement.asType()).toString(), variableElement, formatClass));
                continue;
            }
            this.parameters.add(new MethodParameter(typeUtil.asElement(variableElement.asType()).toString(), variableElement, formatClass));
        }
        this.logMessage = logMessage;
        this.message = message;
    }

    public static final class MethodParameter
    implements Comparable<MethodParameter> {
        private final VariableElement param;
        private final String fullType;
        private final String formatterClass;

        private MethodParameter(String fullType, VariableElement param) {
            this.fullType = fullType;
            this.param = param;
            this.formatterClass = null;
        }

        private MethodParameter(String fullType, VariableElement param, String formatterClass) {
            this.param = param;
            this.fullType = fullType;
            this.formatterClass = formatterClass;
        }

        public boolean isCause() {
            return ElementHelper.isAnnotatedWith(this.param, ElementHelper.CAUSE_ANNOTATION);
        }

        public String fullType() {
            return this.fullType;
        }

        public String getFormatterClass() {
            return this.formatterClass;
        }

        public String name() {
            return this.param.getSimpleName().toString();
        }

        public int hashCode() {
            int prime = 31;
            int hash = 1;
            hash = 31 * hash + (this.fullType == null ? 0 : this.fullType.hashCode());
            hash = 31 * hash + (this.param == null ? 0 : this.param.hashCode());
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MethodParameter)) {
                return false;
            }
            MethodParameter other = (MethodParameter)obj;
            if (this.param == null ? other.param != null : !this.param.equals(other.param)) {
                return false;
            }
            return !(this.fullType == null ? other.fullType != null : !this.fullType.equals(other.fullType));
        }

        @Override
        public int compareTo(MethodParameter other) {
            int result = this.fullType.compareTo(other.fullType);
            result = result != 0 ? result : this.name().compareTo(other.name());
            return result;
        }
    }
}

