/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.validation.validator;

import java.util.ArrayList;
import java.util.Collection;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.jboss.logging.MessageLogger;
import org.jboss.logging.util.ElementHelper;
import org.jboss.logging.validation.ElementValidator;
import org.jboss.logging.validation.ValidationErrorMessage;

public class LoggerReturnTypeValidator
implements ElementValidator {
    @Override
    public Collection<ValidationErrorMessage> validate(TypeElement element, Collection<ExecutableElement> elementMethods) {
        ArrayList<ValidationErrorMessage> errorMessages = new ArrayList<ValidationErrorMessage>();
        if (ElementHelper.isAnnotatedWith(element, MessageLogger.class)) {
            for (ExecutableElement method : elementMethods) {
                if (ElementHelper.isAnnotatedWith(method, ElementHelper.LOG_MESSAGE_ANNOTATION)) {
                    if (method.getReturnType().getKind() == TypeKind.VOID) continue;
                    errorMessages.add(ValidationErrorMessage.of(method, "Methods annotated with %s must have a void return type.", ElementHelper.LOG_MESSAGE_ANNOTATION.getName()));
                    continue;
                }
                if (method.getReturnType().getKind() == TypeKind.VOID) {
                    errorMessages.add(ValidationErrorMessage.of(method, "Cannot have a void return type if the method is not a log method."));
                    continue;
                }
                if (ElementHelper.isAssignableFrom(method.getReturnType(), String.class) || ElementHelper.isAssignableFrom(Throwable.class, method.getReturnType())) continue;
                errorMessages.add(ValidationErrorMessage.of(element, "Method %s has an invalud return type type. Must have a String or Throwable return type if not annotated with %s.", method, ElementHelper.LOG_MESSAGE_ANNOTATION.getName()));
            }
        }
        return errorMessages;
    }
}

